/*
 * Decompiled with CFR 0.152.
 */
package org.marre.mime.encoder;

import java.io.IOException;
import java.io.OutputStream;
import org.marre.mime.MimeBodyPart;
import org.marre.mime.MimeContentType;
import org.marre.mime.MimeHeader;
import org.marre.mime.MimeHeaderParameter;
import org.marre.mime.MimeMultipart;
import org.marre.mime.encoder.MimeEncoder;
import org.marre.util.StringUtil;

public class TextMimeEncoder
implements MimeEncoder {
    private static final int DEFAULT_BOUNDARY_STRING_LENGTH = 35;

    @Override
    public void writeContentType(OutputStream os, MimeBodyPart msg) throws IOException {
        MimeContentType ct = msg.getContentType();
        if (msg instanceof MimeMultipart) {
            String boundary = StringUtil.randString(35);
            ct.setParam("boundary", boundary);
        }
        this.writeHeader(os, ct);
    }

    @Override
    public void writeHeaders(OutputStream os, MimeBodyPart msg) throws IOException {
        for (MimeHeader header : msg.getHeaders()) {
            this.writeHeader(os, header);
        }
        os.write("\r\n".getBytes());
    }

    @Override
    public void writeBody(OutputStream os, MimeBodyPart msg) throws IOException {
        if (msg instanceof MimeMultipart) {
            String ct = msg.getContentType().getValue();
            if (!ct.startsWith("application/vnd.wap.multipart.")) {
                this.writeMultipart(os, (MimeMultipart)msg);
            }
        } else {
            os.write(msg.getBody());
            os.write("\r\n".getBytes());
        }
    }

    protected void writeHeader(OutputStream os, MimeHeader header) throws IOException {
        StringBuilder strBuff = new StringBuilder();
        String name = header.getName();
        String value = header.getValue();
        strBuff.append(name).append(": ").append(value);
        for (MimeHeaderParameter headerParam : header.getParameters()) {
            strBuff.append("; ").append(headerParam.getName()).append("=").append(headerParam.getValue());
        }
        strBuff.append("\r\n");
        os.write(strBuff.toString().getBytes());
    }

    private void writeMultipart(OutputStream os, MimeMultipart multipart) throws IOException {
        MimeContentType ct = multipart.getContentType();
        MimeHeaderParameter boundaryParam = ct.getParameter("boundary");
        String boundary = "--" + boundaryParam.getValue();
        for (MimeBodyPart part : multipart.getBodyParts()) {
            os.write(boundary.getBytes());
            os.write("\r\n".getBytes());
            this.writeContentType(os, part);
            this.writeHeaders(os, part);
            this.writeBody(os, part);
        }
        os.write(boundary.getBytes());
        os.write("--\r\n".getBytes());
    }
}

