/*
 * Decompiled with CFR 0.152.
 */
package org.marre.mms.transport.mm1;

import java.io.IOException;
import java.io.OutputStream;
import org.marre.mime.MimeBodyPart;
import org.marre.mms.MmsException;
import org.marre.mms.MmsHeaders;
import org.marre.wap.WapMimeEncoder;
import org.marre.wap.WspEncodingVersion;
import org.marre.wap.mms.MmsHeaderEncoder;

public final class Mm1Encoder {
    private static final WspEncodingVersion wspEncodingVersion_ = WspEncodingVersion.VERSION_1_3;

    private Mm1Encoder() {
    }

    public static void writeMessageToStream(OutputStream out, MimeBodyPart message, MmsHeaders headers) throws MmsException {
        try {
            Mm1Encoder.writeHeadersToStream(out, headers);
            MmsHeaderEncoder.writeHeaderContentType(wspEncodingVersion_, out, message.getContentType());
            WapMimeEncoder wapMimeEncoder = new WapMimeEncoder();
            wapMimeEncoder.writeBody(out, message);
        }
        catch (IOException ex) {
            throw new MmsException("Failed to write message to stream", ex);
        }
    }

    private static void writeHeadersToStream(OutputStream out, MmsHeaders headers) throws IOException {
        MmsHeaderEncoder.writeHeaderXMmsMessageType(out, headers.getMessageType());
        MmsHeaderEncoder.writeHeaderXMmsTransactionId(out, headers.getTransactionId());
        MmsHeaderEncoder.writeHeaderXMmsMmsVersion(out, headers.getVersion());
        if (headers.getMessageId() != null) {
            MmsHeaderEncoder.writeHeaderMessageId(out, headers.getMessageId());
        }
        MmsHeaderEncoder.writeHeaderDate(out, headers.getDate());
        if (headers.getFrom() != null) {
            MmsHeaderEncoder.writeHeaderFrom(out, headers.getFrom());
        }
        if (headers.getTo() != null) {
            MmsHeaderEncoder.writeHeaderTo(out, headers.getTo());
        }
        if (headers.getSubject() != null) {
            MmsHeaderEncoder.writeHeaderSubject(out, headers.getSubject());
        }
    }
}

