/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsmOperator {
    private static final Logger log_ = LoggerFactory.getLogger(GsmOperator.class);
    private static List<GsmOperator> operators_;
    private final String name_;
    private final String country_;
    private final int mcc_;
    private final int mnc_;

    static {
        GsmOperator.loadOperatorsFromResource("resources/gsmoperators.txt");
    }

    private GsmOperator(String name, String country, int mcc, int mnc) {
        this.name_ = name;
        this.country_ = country;
        this.mcc_ = mcc;
        this.mnc_ = mnc;
    }

    public String getCountry() {
        return this.country_;
    }

    public int getMcc() {
        return this.mcc_;
    }

    public int getMnc() {
        return this.mnc_;
    }

    public String getName() {
        return this.name_;
    }

    public static List<GsmOperator> getOperators() {
        return Collections.unmodifiableList(operators_);
    }

    private static void loadOperatorsFromResource(String resourceName) {
        InputStream in = GsmOperator.class.getResourceAsStream(resourceName);
        if (in != null) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                LinkedList<GsmOperator> operators = new LinkedList<GsmOperator>();
                String row = reader.readLine();
                while (row != null) {
                    StringTokenizer st = new StringTokenizer(row, "|");
                    String country = st.nextToken();
                    String name = st.nextToken();
                    int mcc = Integer.parseInt(st.nextToken());
                    int mnc = Integer.parseInt(st.nextToken());
                    operators.add(new GsmOperator(name, country, mcc, mnc));
                    row = reader.readLine();
                }
                operators_ = Collections.unmodifiableList(operators);
            }
            catch (IOException ex) {
                log_.error("Failed to load mcc and mnc properties", (Throwable)ex);
            }
        }
    }
}

