/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms;

import org.marre.sms.SmsException;
import org.marre.sms.SmsNpi;
import org.marre.sms.SmsTon;

public final class SmsAddress {
    private static final String ALLOWED_DIGITS = "+0123456789*#ab";
    private SmsTon ton_ = SmsTon.INTERNATIONAL;
    private SmsNpi npi_ = SmsNpi.ISDN_TELEPHONE;
    private String address_;

    public SmsAddress(String address) throws SmsException {
        SmsNpi npi = SmsNpi.ISDN_TELEPHONE;
        SmsTon ton = SmsTon.INTERNATIONAL;
        int i = 0;
        while (i < address.length()) {
            char ch = address.charAt(i);
            if (ALLOWED_DIGITS.indexOf(ch) == -1) {
                ton = SmsTon.ALPHANUMERIC;
                npi = SmsNpi.UNKNOWN;
                break;
            }
            ++i;
        }
        this.init(address, ton, npi);
    }

    public SmsAddress(String address, SmsTon ton, SmsNpi npi) throws SmsException {
        this.init(address, ton, npi);
    }

    private void init(String address, SmsTon ton, SmsNpi npi) throws SmsException {
        if (address == null) {
            throw new SmsException("Empty msisdn.");
        }
        this.ton_ = ton;
        this.address_ = address.trim();
        int msisdnLength = this.address_.length();
        if (msisdnLength == 0) {
            throw new SmsException("Empty address.");
        }
        if (ton == SmsTon.ALPHANUMERIC) {
            this.npi_ = SmsNpi.UNKNOWN;
            if (address.length() > 11) {
                throw new SmsException("Alphanumeric address can be at most 11 chars.");
            }
        } else {
            this.npi_ = npi;
            if (this.address_.charAt(0) == '+') {
                this.address_ = this.address_.substring(1);
                --msisdnLength;
            }
            if (msisdnLength > 20) {
                throw new SmsException("Too long address, Max allowed is 20 digits (excluding any inital '+').");
            }
            int i = 0;
            while (i < address.length()) {
                char ch = address.charAt(i);
                if (ALLOWED_DIGITS.indexOf(ch) == -1) {
                    throw new SmsException("Invalid digit in address. '" + ch + "'.");
                }
                ++i;
            }
        }
    }

    public String getAddress() {
        return this.address_;
    }

    public boolean isAlphanumeric() {
        return this.ton_ == SmsTon.ALPHANUMERIC;
    }

    public SmsTon getTypeOfNumber() {
        return this.ton_;
    }

    public SmsNpi getNumberingPlanIdentification() {
        return this.npi_;
    }
}

