/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms;

import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.marre.sms.SmsMessage;
import org.marre.sms.SmsPdu;
import org.marre.sms.SmsPduUtil;
import org.marre.sms.SmsUdhElement;
import org.marre.sms.SmsUdhUtil;
import org.marre.sms.SmsUserData;

public abstract class SmsConcatMessage
implements SmsMessage {
    private static final AtomicInteger rnd_ = new AtomicInteger(new Random().nextInt(65535));

    protected SmsConcatMessage() {
    }

    public abstract SmsUserData getUserData();

    public abstract SmsUdhElement[] getUdhElements();

    private int nextRandom() {
        return rnd_.incrementAndGet() & 0xFF;
    }

    private SmsPdu[] createOctalPdus(SmsUdhElement[] udhElements, SmsUserData ud, int maxBytes) {
        SmsPdu[] smsPdus = null;
        int nMaxConcatChars = maxBytes - 6;
        int nMaxChars = maxBytes;
        if (ud.getLength() <= nMaxChars) {
            smsPdus = new SmsPdu[]{new SmsPdu(udhElements, ud)};
        } else {
            int refno = this.nextRandom();
            int nSms = ud.getLength() / nMaxConcatChars;
            if (ud.getLength() % nMaxConcatChars > 0) {
                ++nSms;
            }
            smsPdus = new SmsPdu[nSms];
            SmsUdhElement[] pduUdhElements = null;
            if (udhElements == null) {
                pduUdhElements = new SmsUdhElement[1];
            } else {
                pduUdhElements = new SmsUdhElement[udhElements.length + 1];
                System.arraycopy(udhElements, 0, pduUdhElements, 1, udhElements.length);
            }
            int i = 0;
            while (i < nSms) {
                pduUdhElements[0] = SmsUdhUtil.get8BitConcatUdh(refno, nSms, i + 1);
                int udOffset = nMaxConcatChars * i;
                int udBytes = ud.getLength() - udOffset;
                if (udBytes > nMaxConcatChars) {
                    udBytes = nMaxConcatChars;
                }
                int udLength = udBytes;
                byte[] pduUd = new byte[udBytes];
                System.arraycopy(ud.getData(), udOffset, pduUd, 0, udBytes);
                smsPdus[i] = new SmsPdu(pduUdhElements, pduUd, udLength, ud.getDcs());
                ++i;
            }
        }
        return smsPdus;
    }

    private SmsPdu[] createUnicodePdus(SmsUdhElement[] udhElements, SmsUserData ud, int maxBytes) {
        SmsPdu[] smsPdus = null;
        int nMaxConcatChars = (maxBytes - 6) / 2;
        if (ud.getLength() <= maxBytes) {
            smsPdus = new SmsPdu[]{new SmsPdu(udhElements, ud)};
        } else {
            int refno = this.nextRandom();
            int nSms = ud.getLength() / 2 / nMaxConcatChars;
            if (ud.getLength() / 2 % nMaxConcatChars > 0) {
                ++nSms;
            }
            smsPdus = new SmsPdu[nSms];
            SmsUdhElement[] pduUdhElements = null;
            if (udhElements == null) {
                pduUdhElements = new SmsUdhElement[1];
            } else {
                pduUdhElements = new SmsUdhElement[udhElements.length + 1];
                System.arraycopy(udhElements, 0, pduUdhElements, 1, udhElements.length);
            }
            int i = 0;
            while (i < nSms) {
                pduUdhElements[0] = SmsUdhUtil.get8BitConcatUdh(refno, nSms, i + 1);
                int udOffset = nMaxConcatChars * i;
                int udLength = ud.getLength() / 2 - udOffset;
                if (udLength > nMaxConcatChars) {
                    udLength = nMaxConcatChars;
                }
                int udBytes = udLength * 2;
                byte[] pduUd = new byte[udBytes];
                System.arraycopy(ud.getData(), udOffset * 2, pduUd, 0, udBytes);
                smsPdus[i] = new SmsPdu(pduUdhElements, pduUd, udBytes, ud.getDcs());
                ++i;
            }
        }
        return smsPdus;
    }

    private SmsPdu[] createSeptetPdus(SmsUdhElement[] udhElements, SmsUserData ud, int maxBytes) {
        SmsPdu[] smsPdus = null;
        int nMaxConcatChars = (maxBytes - 6) * 8 / 7;
        int nMaxChars = maxBytes * 8 / 7;
        if (ud.getLength() <= nMaxChars) {
            smsPdus = new SmsPdu[]{new SmsPdu(udhElements, ud)};
        } else {
            int refno = this.nextRandom();
            String msg = SmsPduUtil.readSeptets(ud.getData());
            if (msg.length() <= ud.getLength()) {
                int cnt = SmsPduUtil.countGSMescapechar(msg);
                nMaxConcatChars -= 2 * cnt;
            }
            int nSms = msg.length() / nMaxConcatChars;
            if (msg.length() % nMaxConcatChars > 0) {
                ++nSms;
            }
            smsPdus = new SmsPdu[nSms];
            SmsUdhElement[] pduUdhElements = null;
            if (udhElements == null) {
                pduUdhElements = new SmsUdhElement[1];
            } else {
                pduUdhElements = new SmsUdhElement[udhElements.length + 1];
                System.arraycopy(udhElements, 0, pduUdhElements, 1, udhElements.length);
            }
            int i = 0;
            while (i < nSms) {
                pduUdhElements[0] = SmsUdhUtil.get8BitConcatUdh(refno, nSms, i + 1);
                int udOffset = nMaxConcatChars * i;
                int udLength = ud.getLength() - udOffset;
                if (udLength > nMaxConcatChars) {
                    udLength = nMaxConcatChars;
                }
                byte[] pduUd = udOffset + udLength > msg.length() ? SmsPduUtil.getSeptets(msg.substring(udOffset)) : SmsPduUtil.getSeptets(msg.substring(udOffset, udOffset + udLength));
                smsPdus[i] = new SmsPdu(pduUdhElements, pduUd, udLength, ud.getDcs());
                ++i;
            }
        }
        return smsPdus;
    }

    @Override
    public SmsPdu[] getPdus() {
        SmsPdu[] smsPdus;
        SmsUserData ud = this.getUserData();
        SmsUdhElement[] udhElements = this.getUdhElements();
        int udhLength = SmsUdhUtil.getTotalSize(udhElements);
        int nBytesLeft = 140 - udhLength;
        switch (ud.getDcs().getAlphabet()) {
            case GSM: {
                smsPdus = this.createSeptetPdus(udhElements, ud, nBytesLeft);
                break;
            }
            case UCS2: {
                smsPdus = this.createUnicodePdus(udhElements, ud, nBytesLeft);
                break;
            }
            case ASCII: {
                smsPdus = this.createOctalPdus(udhElements, ud, nBytesLeft + 159 - 140);
                break;
            }
            default: {
                smsPdus = this.createOctalPdus(udhElements, ud, nBytesLeft);
            }
        }
        return smsPdus;
    }
}

