/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms;

import java.io.Serializable;
import org.marre.sms.DcsGroup;
import org.marre.sms.SmsAlphabet;
import org.marre.sms.SmsMsgClass;

public class SmsDcs
implements Serializable {
    private static final long serialVersionUID = -5797340786616956L;
    protected final byte dcs_;

    public SmsDcs(byte dcs) {
        this.dcs_ = dcs;
    }

    public byte getValue() {
        return this.dcs_;
    }

    public static SmsDcs getGeneralDataCodingDcs(SmsAlphabet alphabet, SmsMsgClass messageClass) {
        byte dcs = 0;
        switch (alphabet) {
            case GSM: 
            case ASCII: {
                dcs = (byte)(dcs | 0);
                break;
            }
            case LATIN1: {
                dcs = (byte)(dcs | 4);
                break;
            }
            case UCS2: {
                dcs = (byte)(dcs | 8);
                break;
            }
            case RESERVED: {
                dcs = (byte)(dcs | 0xC);
            }
        }
        switch (messageClass) {
            case CLASS_0: {
                dcs = (byte)(dcs | 0x10);
                break;
            }
            case CLASS_1: {
                dcs = (byte)(dcs | 0x11);
                break;
            }
            case CLASS_2: {
                dcs = (byte)(dcs | 0x12);
                break;
            }
            case CLASS_3: {
                dcs = (byte)(dcs | 0x13);
                break;
            }
            case CLASS_UNKNOWN: {
                dcs = (byte)(dcs | 0);
            }
        }
        return new SmsDcs(dcs);
    }

    public SmsAlphabet getAlphabet() {
        switch (this.getGroup()) {
            case GENERAL_DATA_CODING: 
            case MESSAGE_WAITING_DISCARD: 
            case MSG_MARK_AUTO_DELETE: {
                if (this.dcs_ == 0) {
                    return SmsAlphabet.ASCII;
                }
                switch (this.dcs_ & 0xC) {
                    case 0: {
                        return SmsAlphabet.ASCII;
                    }
                    case 4: {
                        return SmsAlphabet.LATIN1;
                    }
                    case 8: {
                        return SmsAlphabet.UCS2;
                    }
                    case 12: {
                        return SmsAlphabet.RESERVED;
                    }
                }
                return SmsAlphabet.UCS2;
            }
            case MESSAGE_WAITING_STORE_GSM: {
                return SmsAlphabet.ASCII;
            }
            case MESSAGE_WAITING_STORE_UCS2: {
                return SmsAlphabet.UCS2;
            }
            case DATA_CODING_MESSAGE: {
                switch (this.dcs_ & 4) {
                    case 0: {
                        return SmsAlphabet.ASCII;
                    }
                    case 4: {
                        return SmsAlphabet.LATIN1;
                    }
                }
                return SmsAlphabet.UCS2;
            }
        }
        return SmsAlphabet.UCS2;
    }

    public DcsGroup getGroup() {
        switch (this.dcs_ & 0xC0) {
            case 0: {
                return DcsGroup.GENERAL_DATA_CODING;
            }
            case 64: {
                return DcsGroup.MSG_MARK_AUTO_DELETE;
            }
            case 128: {
                return DcsGroup.RESERVED;
            }
        }
        switch (this.dcs_ & 0xF0) {
            case 192: {
                return DcsGroup.MESSAGE_WAITING_DISCARD;
            }
            case 208: {
                return DcsGroup.MESSAGE_WAITING_STORE_GSM;
            }
            case 224: {
                return DcsGroup.MESSAGE_WAITING_STORE_UCS2;
            }
            case 240: {
                return DcsGroup.DATA_CODING_MESSAGE;
            }
        }
        return DcsGroup.GENERAL_DATA_CODING;
    }

    public SmsMsgClass getMessageClass() {
        switch (this.getGroup()) {
            case GENERAL_DATA_CODING: {
                if (this.dcs_ == 0) {
                    return SmsMsgClass.CLASS_UNKNOWN;
                }
                switch (this.dcs_ & 0x13) {
                    case 16: {
                        return SmsMsgClass.CLASS_0;
                    }
                    case 17: {
                        return SmsMsgClass.CLASS_1;
                    }
                    case 18: {
                        return SmsMsgClass.CLASS_2;
                    }
                    case 19: {
                        return SmsMsgClass.CLASS_3;
                    }
                }
                return SmsMsgClass.CLASS_UNKNOWN;
            }
            case DATA_CODING_MESSAGE: {
                switch (this.dcs_ & 3) {
                    case 0: {
                        return SmsMsgClass.CLASS_0;
                    }
                    case 1: {
                        return SmsMsgClass.CLASS_1;
                    }
                    case 2: {
                        return SmsMsgClass.CLASS_2;
                    }
                    case 3: {
                        return SmsMsgClass.CLASS_3;
                    }
                }
                return SmsMsgClass.CLASS_UNKNOWN;
            }
        }
        return SmsMsgClass.CLASS_UNKNOWN;
    }
}

