/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms;

public final class SmsNpi {
    public static final SmsNpi UNKNOWN = new SmsNpi(0, "UNKNOWN");
    public static final SmsNpi ISDN_TELEPHONE = new SmsNpi(1, "ISDN_TELEPHONE");
    public static final SmsNpi DATA = new SmsNpi(3, "DATA");
    public static final SmsNpi TELEX = new SmsNpi(4, "TELEX");
    public static final SmsNpi NATIONAL = new SmsNpi(8, "NATIONAL");
    public static final SmsNpi PRIVATE = new SmsNpi(9, "PRIVATE");
    public static final SmsNpi ERMES = new SmsNpi(16, "ERMES");
    private final int value;
    private final String name;

    private SmsNpi(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public static SmsNpi valueOf(int value) {
        switch (value) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return ISDN_TELEPHONE;
            }
            case 3: {
                return DATA;
            }
            case 4: {
                return TELEX;
            }
            case 8: {
                return NATIONAL;
            }
            case 9: {
                return PRIVATE;
            }
            case 16: {
                return ERMES;
            }
        }
        return new SmsNpi(value, String.valueOf(value));
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmsNpi smsNpi = (SmsNpi)o;
        return this.value == smsNpi.value;
    }

    public int hashCode() {
        return this.value;
    }
}

