/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.marre.sms.SmsDcs;
import org.marre.sms.SmsUdhElement;
import org.marre.sms.SmsUdhUtil;
import org.marre.sms.SmsUserData;

public class SmsPdu {
    protected SmsUdhElement[] udhElements_;
    protected SmsUserData ud_;

    public SmsPdu() {
    }

    public SmsPdu(SmsUdhElement[] udhElements, byte[] ud, int udLength, SmsDcs dcs) {
        this.setUserDataHeaders(udhElements);
        this.setUserData(ud, udLength, dcs);
    }

    public SmsPdu(SmsUdhElement[] udhElements, SmsUserData ud) {
        this.setUserDataHeaders(udhElements);
        this.setUserData(ud);
    }

    public void setUserDataHeaders(SmsUdhElement[] udhElements) {
        if (udhElements != null) {
            this.udhElements_ = new SmsUdhElement[udhElements.length];
            System.arraycopy(udhElements, 0, this.udhElements_, 0, udhElements.length);
        } else {
            this.udhElements_ = null;
        }
    }

    public byte[] getUserDataHeaders() {
        if (this.udhElements_ == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(100);
        byte length = (byte)SmsUdhUtil.getTotalSize(this.udhElements_);
        if (length > 0) {
            baos.write(length);
            try {
                SmsUdhElement[] smsUdhElementArray = this.udhElements_;
                int n = this.udhElements_.length;
                int n2 = 0;
                while (n2 < n) {
                    SmsUdhElement anUdhElements_ = smsUdhElementArray[n2];
                    anUdhElements_.writeTo(baos);
                    ++n2;
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to write to ByteArrayOutputStream");
            }
        }
        return baos.toByteArray();
    }

    public void setUserData(byte[] ud, int udLength, SmsDcs dcs) {
        this.ud_ = new SmsUserData(ud, udLength, dcs);
    }

    public void setUserData(SmsUserData ud) {
        this.ud_ = ud;
    }

    public SmsUserData getUserData() {
        return this.ud_;
    }

    public SmsDcs getDcs() {
        return this.ud_.getDcs();
    }
}

