/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms;

import com.zx.sms.codec.cmpp.wap.LongMessageFrameHolder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class SmsPduUtil {
    private static final char[][] grcAlphabetRemapping = new char[][]{{'\u0386', 'A'}, {'\u0388', 'E'}, {'\u0389', 'H'}, {'\u038a', 'I'}, {'\u038c', 'O'}, {'\u038e', 'Y'}, {'\u038f', '\u03a9'}, {'\u0390', 'I'}, {'\u0391', 'A'}, {'\u0392', 'B'}, {'\u0393', '\u0393'}, {'\u0394', '\u0394'}, {'\u0395', 'E'}, {'\u0396', 'Z'}, {'\u0397', 'H'}, {'\u0398', '\u0398'}, {'\u0399', 'I'}, {'\u039a', 'K'}, {'\u039b', '\u039b'}, {'\u039c', 'M'}, {'\u039d', 'N'}, {'\u039e', '\u039e'}, {'\u039f', 'O'}, {'\u03a0', '\u03a0'}, {'\u03a1', 'P'}, {'\u03a3', '\u03a3'}, {'\u03a4', 'T'}, {'\u03a5', 'Y'}, {'\u03a6', '\u03a6'}, {'\u03a7', 'X'}, {'\u03a8', '\u03a8'}, {'\u03a9', '\u03a9'}, {'\u03aa', 'I'}, {'\u03ab', 'Y'}, {'\u03ac', 'A'}, {'\u03ad', 'E'}, {'\u03ae', 'H'}, {'\u03af', 'I'}, {'\u03b0', 'Y'}, {'\u03b1', 'A'}, {'\u03b2', 'B'}, {'\u03b3', '\u0393'}, {'\u03b4', '\u0394'}, {'\u03b5', 'E'}, {'\u03b6', 'Z'}, {'\u03b7', 'H'}, {'\u03b8', '\u0398'}, {'\u03b9', 'I'}, {'\u03ba', 'K'}, {'\u03bb', '\u039b'}, {'\u03bc', 'M'}, {'\u03bd', 'N'}, {'\u03be', '\u039e'}, {'\u03bf', 'O'}, {'\u03c0', '\u03a0'}, {'\u03c1', 'P'}, {'\u03c2', '\u03a3'}, {'\u03c3', '\u03a3'}, {'\u03c4', 'T'}, {'\u03c5', 'Y'}, {'\u03c6', '\u03a6'}, {'\u03c7', 'X'}, {'\u03c8', '\u03a8'}, {'\u03c9', '\u03a9'}, {'\u03ca', 'I'}, {'\u03cb', 'Y'}, {'\u03cc', 'O'}, {'\u03cd', 'Y'}, {'\u03ce', '\u03a9'}};
    private static final char[] extAlphabet = new char[]{'\f', '^', '{', '}', '\\', '[', '~', ']', '|', '\u20ac'};
    private static final String[] extBytes = new String[]{"1b0a", "1b14", "1b28", "1b29", "1b2f", "1b3c", "1b3d", "1b3e", "1b40", "1b65"};
    private static final char[] stdAlphabet = new char[]{'@', '\u00a3', '$', '\u00a5', '\u00e8', '\u00e9', '\u00f9', '\u00ec', '\u00f2', '\u00e7', '\n', '\u00d8', '\u00f8', '\r', '\u00c5', '\u00e5', '\u0394', '_', '\u03a6', '\u0393', '\u039b', '\u03a9', '\u03a0', '\u03a8', '\u03a3', '\u0398', '\u039e', '\u00a0', '\u00c6', '\u00e6', '\u00df', '\u00c9', ' ', '!', '\"', '#', '\u00a4', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '\u00a1', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c4', '\u00d6', '\u00d1', '\u00dc', '\u00a7', '\u00bf', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00e4', '\u00f6', '\u00f1', '\u00fc', '\u00e0'};

    private SmsPduUtil() {
    }

    public static byte[] getSeptets(String msg) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(140);
        try {
            SmsPduUtil.writeSeptets(baos, msg);
            baos.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return baos.toByteArray();
    }

    static byte[] septetStream2octetStream(byte[] septets) {
        int octetLength = (int)Math.ceil((double)(septets.length * 7) / 8.0);
        byte[] octets = new byte[octetLength];
        int i = 0;
        while (i < septets.length) {
            int j = 0;
            while (j < 7) {
                if ((septets[i] & 1 << j) != 0) {
                    int bitIndex = i * 7 + j;
                    int n = bitIndex >>> 3;
                    octets[n] = (byte)(octets[n] | 1 << (bitIndex & 7));
                }
                ++j;
            }
            ++i;
        }
        return octets;
    }

    public static void writeSeptets(OutputStream os, String msg) throws IOException {
        byte[] bytes = SmsPduUtil.stringToUnencodedSeptets(msg);
        os.write(SmsPduUtil.septetStream2octetStream(bytes));
    }

    public static String readSeptets(byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] ba = LongMessageFrameHolder.octetStream2septetStream(data);
        return SmsPduUtil.unencodedSeptetsToString(ba);
    }

    public static void writeBcdNumber(OutputStream os, String number) throws IOException {
        int bcd = 0;
        int n = 0;
        int i = 0;
        while (i < number.length()) {
            switch (number.charAt(i)) {
                case '0': {
                    bcd |= 0;
                    break;
                }
                case '1': {
                    bcd |= 0x10;
                    break;
                }
                case '2': {
                    bcd |= 0x20;
                    break;
                }
                case '3': {
                    bcd |= 0x30;
                    break;
                }
                case '4': {
                    bcd |= 0x40;
                    break;
                }
                case '5': {
                    bcd |= 0x50;
                    break;
                }
                case '6': {
                    bcd |= 0x60;
                    break;
                }
                case '7': {
                    bcd |= 0x70;
                    break;
                }
                case '8': {
                    bcd |= 0x80;
                    break;
                }
                case '9': {
                    bcd |= 0x90;
                    break;
                }
                case '*': {
                    bcd |= 0xA0;
                    break;
                }
                case '#': {
                    bcd |= 0xB0;
                    break;
                }
                case 'a': {
                    bcd |= 0xC0;
                    break;
                }
                case 'b': {
                    bcd |= 0xE0;
                }
            }
            if (++n == 2) {
                os.write(bcd);
                n = 0;
                bcd = 0;
            } else {
                bcd >>= 4;
            }
            ++i;
        }
        if (n == 1) {
            os.write(bcd |= 0xF0);
        }
    }

    public static String readBcdNumber(InputStream is, int length) throws IOException {
        byte[] arr = new byte[length];
        is.read(arr, 0, length);
        return SmsPduUtil.readBcdNumber(arr, 0, length);
    }

    public static String readBcdNumber(byte[] data, int offset, int length) {
        StringBuilder out = new StringBuilder();
        int i = offset;
        while (i < offset + length) {
            int arrb = data[i];
            if ((data[i] & 0xF) <= 9) {
                out.append("").append(data[i] & 0xF);
            }
            if ((data[i] & 0xF) == 10) {
                out.append("*");
            }
            if ((data[i] & 0xF) == 11) {
                out.append("#");
            }
            if (((arrb >>>= 4) & 0xF) <= 9) {
                out.append("").append(arrb & 0xF);
            }
            if ((arrb & 0xF) == 10) {
                out.append("*");
            }
            if ((arrb & 0xF) == 11) {
                out.append("#");
            }
            ++i;
        }
        return out.toString();
    }

    public static void arrayCopy(byte[] src, int srcStart, byte[] dest, int destStart, int destBitOffset, int lengthInBits) {
        int c = 0;
        int nBytes = lengthInBits / 8;
        int nRestBits = lengthInBits % 8;
        int i = 0;
        while (i < nBytes) {
            int n = destStart + i;
            dest[n] = (byte)(dest[n] | (byte)((c |= (src[srcStart + i] & 0xFF) << destBitOffset) & 0xFF));
            c >>>= 8;
            ++i;
        }
        if (nRestBits > 0) {
            c |= (src[srcStart + nBytes] & 255 >> 8 - nRestBits) << destBitOffset;
        }
        if (nRestBits + destBitOffset > 0) {
            int n = destStart + nBytes;
            dest[n] = (byte)(dest[n] | c & 0xFF);
        }
    }

    public static byte[] stringToUnencodedSeptets(String s) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int k = 0;
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            int index = -1;
            int j = 0;
            while (j < extAlphabet.length) {
                if (extAlphabet[j] == ch) {
                    index = j;
                    break;
                }
                ++j;
            }
            if (index != -1) {
                baos.write((byte)Integer.parseInt(extBytes[index].substring(0, 2), 16));
                ++k;
                baos.write((byte)Integer.parseInt(extBytes[index].substring(2, 4), 16));
                ++k;
            } else {
                index = -1;
                j = 0;
                while (j < stdAlphabet.length) {
                    if (stdAlphabet[j] == ch) {
                        index = j;
                        baos.write((byte)j);
                        ++k;
                        break;
                    }
                    ++j;
                }
                if (index == -1) {
                    j = 0;
                    while (j < grcAlphabetRemapping.length) {
                        if (grcAlphabetRemapping[j][0] == ch) {
                            index = j;
                            ch = grcAlphabetRemapping[j][1];
                            break;
                        }
                        ++j;
                    }
                    if (index != -1) {
                        j = 0;
                        while (j < stdAlphabet.length) {
                            if (stdAlphabet[j] == ch) {
                                index = j;
                                baos.write((byte)j);
                                ++k;
                                break;
                            }
                            ++j;
                        }
                    } else {
                        baos.write(32);
                        ++k;
                    }
                }
            }
            ++i;
        }
        return baos.toByteArray();
    }

    public static String unencodedSeptetsToString(byte[] bytes) {
        StringBuffer text = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            if (bytes[i] == 27) {
                String extChar = "1b" + Integer.toHexString(bytes[++i]);
                int j = 0;
                while (j < extBytes.length) {
                    if (extBytes[j].equalsIgnoreCase(extChar)) {
                        text.append(extAlphabet[j]);
                    }
                    ++j;
                }
            } else {
                text.append(stdAlphabet[bytes[i]]);
            }
            ++i;
        }
        return text.toString();
    }

    public static int countGSMescapechar(String msg) {
        int i = 0;
        int j = 0;
        while (j < msg.length()) {
            char ch = msg.charAt(j);
            int k = 0;
            while (k < extAlphabet.length) {
                if (extAlphabet[k] == ch) {
                    ++i;
                    break;
                }
                ++k;
            }
            ++j;
        }
        return i;
    }
}

