/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms;

import com.zx.sms.common.GlobalConstance;
import com.zx.sms.common.util.CMPPCommonUtil;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.marre.sms.SmsAlphabet;
import org.marre.sms.SmsConcatMessage;
import org.marre.sms.SmsDcs;
import org.marre.sms.SmsMsgClass;
import org.marre.sms.SmsPduUtil;
import org.marre.sms.SmsUdhElement;
import org.marre.sms.SmsUserData;

public class SmsTextMessage
extends SmsConcatMessage
implements Serializable {
    private static final long serialVersionUID = -2655575183111164853L;
    private String text_;
    private SmsDcs dcs_;

    public SmsTextMessage(String msg, SmsDcs dcs) {
        this.setText(msg, dcs);
    }

    public SmsTextMessage(String msg, SmsAlphabet alphabet, SmsMsgClass messageClass) {
        this(msg, SmsDcs.getGeneralDataCodingDcs(alphabet, messageClass));
    }

    public SmsTextMessage(String msg) {
        if (SmsTextMessage.haswidthChar(msg)) {
            this.setText(msg, SmsDcs.getGeneralDataCodingDcs(SmsAlphabet.UCS2, SmsMsgClass.CLASS_UNKNOWN));
        } else {
            this.setText(msg, GlobalConstance.defaultmsgfmt);
        }
    }

    public String getText() {
        return this.text_;
    }

    public void setText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null, use an empty string instead.");
        }
        this.text_ = text;
    }

    public void setText(String text, SmsDcs dcs) {
        if (text == null) {
            this.text_ = "";
        }
        if (dcs == null) {
            throw new IllegalArgumentException("dcs cannot be null.");
        }
        this.text_ = text;
        this.dcs_ = dcs;
    }

    public SmsDcs getDcs() {
        return this.dcs_;
    }

    @Override
    public SmsUserData getUserData() {
        SmsUserData ud;
        SmsAlphabet alp = this.dcs_.getAlphabet();
        switch (alp) {
            case GSM: {
                byte[] bs = SmsPduUtil.getSeptets(this.text_);
                ud = new SmsUserData(bs, bs.length * 8 / 7, this.dcs_);
                break;
            }
            case ASCII: 
            case LATIN1: 
            case UCS2: 
            case RESERVED: {
                ud = new SmsUserData(this.text_.getBytes(CMPPCommonUtil.switchCharset(alp)), this.dcs_);
                break;
            }
            default: {
                ud = new SmsUserData(this.text_.getBytes(CMPPCommonUtil.switchCharset(SmsAlphabet.UCS2)), SmsDcs.getGeneralDataCodingDcs(SmsAlphabet.UCS2, SmsMsgClass.CLASS_UNKNOWN));
            }
        }
        return ud;
    }

    @Override
    public SmsUdhElement[] getUdhElements() {
        return null;
    }

    private static boolean haswidthChar(String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return false;
        }
        byte[] bytes = content.getBytes();
        int i = 0;
        while (i < bytes.length) {
            if ((bytes[i] & 0xFFFFFF80) == -128) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        return this.getText();
    }
}

