/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.marre.sms.SmsPort;
import org.marre.sms.SmsUdhElement;
import org.marre.sms.SmsUdhIei;
import org.marre.sms.SmsUserData;

public final class SmsUdhUtil {
    public static final int PDUMAXLENGTH = 140;
    public static final int ASCIIMAXLENGTH = 159;

    private SmsUdhUtil() {
    }

    public static int getTotalSize(SmsUdhElement[] udhElements) {
        int totLength = 0;
        if (udhElements == null) {
            return 0;
        }
        SmsUdhElement[] smsUdhElementArray = udhElements;
        int n = udhElements.length;
        int n2 = 0;
        while (n2 < n) {
            SmsUdhElement udhElement = smsUdhElementArray[n2];
            totLength += udhElement.getTotalSize();
            ++n2;
        }
        return totLength;
    }

    public static byte[] toByteArray(SmsUdhElement[] udhElements) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(100);
        if (udhElements == null) {
            return new byte[0];
        }
        baos.write((byte)SmsUdhUtil.getTotalSize(udhElements));
        try {
            SmsUdhElement[] smsUdhElementArray = udhElements;
            int n = udhElements.length;
            int n2 = 0;
            while (n2 < n) {
                SmsUdhElement udhElement = smsUdhElementArray[n2];
                udhElement.writeTo(baos);
                ++n2;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return baos.toByteArray();
    }

    public static boolean isConcat(SmsUserData ud, byte[] udh) {
        int maxChars;
        int udLength = ud.getLength();
        int bytesLeft = 140;
        if (udh != null) {
            bytesLeft -= udh.length;
        }
        switch (ud.getDcs().getAlphabet()) {
            case GSM: {
                maxChars = bytesLeft * 8 / 7;
                break;
            }
            case UCS2: {
                maxChars = bytesLeft / 2;
                break;
            }
            case ASCII: {
                maxChars = bytesLeft + 159 - 140;
                break;
            }
            default: {
                maxChars = bytesLeft;
            }
        }
        return udLength > maxChars;
    }

    public static SmsUdhElement get8BitConcatUdh(int refNr, int totalNumberOfSms, int seqNr) {
        byte[] udh = new byte[]{(byte)(refNr & 0xFF), (byte)(totalNumberOfSms & 0xFF), (byte)(seqNr & 0xFF)};
        return new SmsUdhElement(SmsUdhIei.CONCATENATED_8BIT, udh);
    }

    public static SmsUdhElement getMessageWaitingUdh(boolean storeMsg, int msgType, int msgCount) {
        byte[] udh = new byte[2];
        udh[0] = (byte)(msgType & 0x7F);
        if (storeMsg) {
            udh[0] = (byte)(udh[0] | 0xFFFFFF80);
        }
        udh[1] = (byte)(msgCount & 0xFF);
        return new SmsUdhElement(SmsUdhIei.SPECIAL_MESSAGE, udh);
    }

    public static SmsUdhElement get8BitApplicationPortUdh(SmsPort destPort, SmsPort origPort) {
        byte[] udh = new byte[2];
        int destPortNo = destPort.getPort();
        int origPortNo = origPort.getPort();
        udh[0] = (byte)(destPortNo & 0xFF);
        udh[1] = (byte)(origPortNo & 0xFF);
        return new SmsUdhElement(SmsUdhIei.APP_PORT_8BIT, udh);
    }

    public static SmsUdhElement get16BitApplicationPortUdh(SmsPort destPort, SmsPort origPort) {
        byte[] udh = new byte[4];
        int destPortNo = destPort.getPort();
        int origPortNo = origPort.getPort();
        udh[0] = (byte)(destPortNo >> 8 & 0xFF);
        udh[1] = (byte)(destPortNo & 0xFF);
        udh[2] = (byte)(origPortNo >> 8 & 0xFF);
        udh[3] = (byte)(origPortNo & 0xFF);
        return new SmsUdhElement(SmsUdhIei.APP_PORT_16BIT, udh);
    }

    public static SmsUdhElement get16BitConcatUdh(int refNr, int totalNumberOfSms, int seqNr) {
        byte[] udh = new byte[]{(byte)(refNr >> 8 & 0xFF), (byte)(refNr & 0xFF), (byte)(totalNumberOfSms & 0xFF), (byte)(seqNr & 0xFF)};
        return new SmsUdhElement(SmsUdhIei.CONCATENATED_16BIT, udh);
    }
}

