/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms.nokia;

import com.zx.sms.common.util.StandardCharsets;
import org.marre.sms.nokia.NokiaItemType;
import org.marre.sms.nokia.NokiaMultipartMessage;
import org.marre.sms.nokia.OtaBitmap;

public class NokiaPictureMessage
extends NokiaMultipartMessage {
    private static final long serialVersionUID = 4494512073470660074L;

    public NokiaPictureMessage(OtaBitmap otaBitmap, String msg) {
        this(otaBitmap, msg, false);
    }

    public NokiaPictureMessage(byte[] bitmapData, String msg) {
        this(bitmapData, msg, false);
    }

    public NokiaPictureMessage(OtaBitmap otaBitmap, String msg, boolean asUnicode) {
        this(otaBitmap.getBytes(), msg, asUnicode);
    }

    public NokiaPictureMessage(byte[] bitmapData, String msg, boolean asUnicode) {
        this.addBitmap(bitmapData);
        this.addText(msg, asUnicode);
    }

    private void addBitmap(byte[] bitmapData) {
        this.addMultipart(NokiaItemType.OTA_BITMAP, bitmapData);
    }

    private void addBitmap(OtaBitmap otaBitmap) {
        this.addMultipart(NokiaItemType.OTA_BITMAP, otaBitmap.getBytes());
    }

    private void addText(String msg, boolean asUnicode) {
        if (asUnicode) {
            this.addMultipart(NokiaItemType.TEXT_UNICODE, msg.getBytes(StandardCharsets.UTF_16BE));
        } else {
            this.addMultipart(NokiaItemType.TEXT_ISO_8859_1, msg.getBytes(StandardCharsets.ISO_8859_1));
        }
    }
}

