/*
 * Decompiled with CFR 0.152.
 */
package org.marre.wap;

import com.zx.sms.common.util.StandardCharsets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.marre.mime.MimeHeader;
import org.marre.mime.MimeHeaderParameter;
import org.marre.wap.WspEncodingVersion;

public final class WspUtil {
    private static final Map<String, Integer> wspHeaders_;
    private static final Map<String, Integer> wspContentTypes_;
    private static final Map<String, Integer> wspParameters_;
    private static final Map<String, Integer> wspPushAppTypes_;
    private static final int[] WELL_KNOWN_HEADER_ID_WSP_11;
    private static final int[] WELL_KNOWN_HEADER_ID_WSP_12;
    private static final int[] WELL_KNOWN_HEADER_ID_WSP_13;
    private static final int[] WELL_KNOWN_HEADER_ID_WSP_14;
    private static final int[] WELL_KNOWN_PARAMETER_ID_WSP_11;
    private static final int[] WELL_KNOWN_PARAMETER_ID_WSP_12;
    private static final int[] WELL_KNOWN_PARAMETER_ID_WSP_13;
    private static final int[] WELL_KNOWN_PARAMETER_ID_WSP_14;
    private static final int[] PARAMETER_TYPES;

    static {
        int[] nArray = new int[65];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        nArray[12] = 12;
        nArray[13] = 13;
        nArray[14] = 14;
        nArray[15] = 15;
        nArray[16] = 16;
        nArray[17] = 17;
        nArray[18] = 18;
        nArray[19] = 19;
        nArray[20] = 20;
        nArray[21] = 21;
        nArray[22] = 22;
        nArray[23] = 23;
        nArray[24] = 24;
        nArray[25] = 25;
        nArray[26] = 26;
        nArray[27] = 27;
        nArray[28] = 28;
        nArray[29] = 29;
        nArray[30] = 30;
        nArray[31] = 31;
        nArray[32] = 32;
        nArray[33] = 33;
        nArray[34] = 34;
        nArray[35] = 35;
        nArray[36] = 36;
        nArray[37] = 37;
        nArray[38] = 38;
        nArray[39] = 39;
        nArray[40] = 40;
        nArray[41] = 41;
        nArray[42] = 42;
        nArray[43] = 43;
        nArray[44] = 44;
        nArray[45] = 45;
        nArray[46] = 46;
        nArray[47] = -1;
        nArray[48] = -1;
        nArray[49] = -1;
        nArray[50] = -1;
        nArray[51] = -1;
        nArray[52] = -1;
        nArray[53] = -1;
        nArray[54] = -1;
        nArray[55] = -1;
        nArray[56] = -1;
        nArray[57] = -1;
        nArray[58] = -1;
        nArray[59] = -1;
        nArray[60] = -1;
        nArray[61] = -1;
        nArray[62] = -1;
        nArray[63] = -1;
        nArray[64] = -1;
        WELL_KNOWN_HEADER_ID_WSP_11 = nArray;
        int[] nArray2 = new int[65];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        nArray2[5] = 5;
        nArray2[6] = 6;
        nArray2[7] = 7;
        nArray2[8] = 8;
        nArray2[9] = 9;
        nArray2[10] = 10;
        nArray2[11] = 11;
        nArray2[12] = 12;
        nArray2[13] = 13;
        nArray2[14] = 14;
        nArray2[15] = 15;
        nArray2[16] = 16;
        nArray2[17] = 17;
        nArray2[18] = 18;
        nArray2[19] = 19;
        nArray2[20] = 20;
        nArray2[21] = 21;
        nArray2[22] = 22;
        nArray2[23] = 23;
        nArray2[24] = 24;
        nArray2[25] = 25;
        nArray2[26] = 26;
        nArray2[27] = 27;
        nArray2[28] = 28;
        nArray2[29] = 29;
        nArray2[30] = 30;
        nArray2[31] = 31;
        nArray2[32] = 32;
        nArray2[33] = 33;
        nArray2[34] = 34;
        nArray2[35] = 35;
        nArray2[36] = 36;
        nArray2[37] = 37;
        nArray2[38] = 38;
        nArray2[39] = 39;
        nArray2[40] = 40;
        nArray2[41] = 41;
        nArray2[42] = 42;
        nArray2[43] = 43;
        nArray2[44] = 44;
        nArray2[45] = 45;
        nArray2[46] = 46;
        nArray2[47] = 47;
        nArray2[48] = 48;
        nArray2[49] = 49;
        nArray2[50] = 50;
        nArray2[51] = 51;
        nArray2[52] = 52;
        nArray2[53] = 53;
        nArray2[54] = 54;
        nArray2[55] = 55;
        nArray2[56] = -1;
        nArray2[57] = -1;
        nArray2[58] = -1;
        nArray2[59] = -1;
        nArray2[60] = -1;
        nArray2[61] = -1;
        nArray2[62] = -1;
        nArray2[63] = -1;
        nArray2[64] = -1;
        WELL_KNOWN_HEADER_ID_WSP_12 = nArray2;
        int[] nArray3 = new int[65];
        nArray3[1] = 59;
        nArray3[2] = 60;
        nArray3[3] = 3;
        nArray3[4] = 4;
        nArray3[5] = 5;
        nArray3[6] = 6;
        nArray3[7] = 7;
        nArray3[8] = 61;
        nArray3[9] = 9;
        nArray3[10] = 10;
        nArray3[11] = 11;
        nArray3[12] = 12;
        nArray3[13] = 13;
        nArray3[14] = 14;
        nArray3[15] = 15;
        nArray3[16] = 62;
        nArray3[17] = 17;
        nArray3[18] = 18;
        nArray3[19] = 19;
        nArray3[20] = 20;
        nArray3[21] = 21;
        nArray3[22] = 22;
        nArray3[23] = 23;
        nArray3[24] = 24;
        nArray3[25] = 25;
        nArray3[26] = 26;
        nArray3[27] = 27;
        nArray3[28] = 28;
        nArray3[29] = 29;
        nArray3[30] = 30;
        nArray3[31] = 31;
        nArray3[32] = 32;
        nArray3[33] = 33;
        nArray3[34] = 34;
        nArray3[35] = 35;
        nArray3[36] = 36;
        nArray3[37] = 37;
        nArray3[38] = 38;
        nArray3[39] = 39;
        nArray3[40] = 40;
        nArray3[41] = 41;
        nArray3[42] = 42;
        nArray3[43] = 43;
        nArray3[44] = 44;
        nArray3[45] = 45;
        nArray3[46] = 46;
        nArray3[47] = 47;
        nArray3[48] = 48;
        nArray3[49] = 49;
        nArray3[50] = 50;
        nArray3[51] = 51;
        nArray3[52] = 52;
        nArray3[53] = 53;
        nArray3[54] = 54;
        nArray3[55] = 55;
        nArray3[56] = 56;
        nArray3[57] = 57;
        nArray3[58] = 58;
        nArray3[59] = 63;
        nArray3[60] = 64;
        nArray3[61] = 65;
        nArray3[62] = 66;
        nArray3[63] = 67;
        nArray3[64] = -1;
        WELL_KNOWN_HEADER_ID_WSP_13 = nArray3;
        int[] nArray4 = new int[65];
        nArray4[1] = 59;
        nArray4[2] = 60;
        nArray4[3] = 3;
        nArray4[4] = 4;
        nArray4[5] = 5;
        nArray4[6] = 6;
        nArray4[7] = 7;
        nArray4[8] = 71;
        nArray4[9] = 9;
        nArray4[10] = 10;
        nArray4[11] = 11;
        nArray4[12] = 12;
        nArray4[13] = 13;
        nArray4[14] = 14;
        nArray4[15] = 15;
        nArray4[16] = 62;
        nArray4[17] = 17;
        nArray4[18] = 18;
        nArray4[19] = 19;
        nArray4[20] = 20;
        nArray4[21] = 21;
        nArray4[22] = 22;
        nArray4[23] = 23;
        nArray4[24] = 24;
        nArray4[25] = 25;
        nArray4[26] = 26;
        nArray4[27] = 27;
        nArray4[28] = 28;
        nArray4[29] = 29;
        nArray4[30] = 30;
        nArray4[31] = 31;
        nArray4[32] = 32;
        nArray4[33] = 33;
        nArray4[34] = 34;
        nArray4[35] = 35;
        nArray4[36] = 36;
        nArray4[37] = 37;
        nArray4[38] = 38;
        nArray4[39] = 39;
        nArray4[40] = 40;
        nArray4[41] = 41;
        nArray4[42] = 42;
        nArray4[43] = 43;
        nArray4[44] = 44;
        nArray4[45] = 45;
        nArray4[46] = 69;
        nArray4[47] = 47;
        nArray4[48] = 48;
        nArray4[49] = 49;
        nArray4[50] = 50;
        nArray4[51] = 51;
        nArray4[52] = 52;
        nArray4[53] = 53;
        nArray4[54] = 54;
        nArray4[55] = 68;
        nArray4[56] = 56;
        nArray4[57] = 57;
        nArray4[58] = 58;
        nArray4[59] = 63;
        nArray4[60] = 64;
        nArray4[61] = 65;
        nArray4[62] = 66;
        nArray4[63] = 67;
        nArray4[64] = 70;
        WELL_KNOWN_HEADER_ID_WSP_14 = nArray4;
        int[] nArray5 = new int[22];
        nArray5[1] = 1;
        nArray5[2] = 2;
        nArray5[3] = 3;
        nArray5[4] = 5;
        nArray5[5] = 6;
        nArray5[6] = 7;
        nArray5[7] = 8;
        nArray5[8] = -1;
        nArray5[9] = -1;
        nArray5[10] = -1;
        nArray5[11] = -1;
        nArray5[12] = -1;
        nArray5[13] = -1;
        nArray5[14] = -1;
        nArray5[15] = -1;
        nArray5[16] = -1;
        nArray5[17] = -1;
        nArray5[18] = -1;
        nArray5[19] = -1;
        nArray5[20] = -1;
        nArray5[21] = -1;
        WELL_KNOWN_PARAMETER_ID_WSP_11 = nArray5;
        int[] nArray6 = new int[22];
        nArray6[1] = 1;
        nArray6[2] = 2;
        nArray6[3] = 3;
        nArray6[4] = 5;
        nArray6[5] = 6;
        nArray6[6] = 7;
        nArray6[7] = 8;
        nArray6[8] = 9;
        nArray6[9] = 10;
        nArray6[10] = 11;
        nArray6[11] = -1;
        nArray6[12] = -1;
        nArray6[13] = -1;
        nArray6[14] = -1;
        nArray6[15] = -1;
        nArray6[16] = -1;
        nArray6[17] = -1;
        nArray6[18] = -1;
        nArray6[19] = -1;
        nArray6[20] = -1;
        nArray6[21] = -1;
        WELL_KNOWN_PARAMETER_ID_WSP_12 = nArray6;
        int[] nArray7 = new int[22];
        nArray7[1] = 1;
        nArray7[2] = 2;
        nArray7[3] = 3;
        nArray7[4] = 5;
        nArray7[5] = 6;
        nArray7[6] = 7;
        nArray7[7] = 8;
        nArray7[8] = 9;
        nArray7[9] = 10;
        nArray7[10] = 11;
        nArray7[11] = 12;
        nArray7[12] = 13;
        nArray7[13] = 14;
        nArray7[14] = 15;
        nArray7[15] = 16;
        nArray7[16] = -1;
        nArray7[17] = -1;
        nArray7[18] = -1;
        nArray7[19] = -1;
        nArray7[20] = -1;
        nArray7[21] = -1;
        WELL_KNOWN_PARAMETER_ID_WSP_13 = nArray7;
        int[] nArray8 = new int[22];
        nArray8[1] = 1;
        nArray8[2] = 2;
        nArray8[3] = 3;
        nArray8[4] = 23;
        nArray8[5] = 24;
        nArray8[6] = 7;
        nArray8[7] = 8;
        nArray8[8] = 9;
        nArray8[9] = 25;
        nArray8[10] = 26;
        nArray8[11] = 27;
        nArray8[12] = 28;
        nArray8[13] = 14;
        nArray8[14] = 29;
        nArray8[15] = 16;
        nArray8[16] = 17;
        nArray8[17] = 18;
        nArray8[18] = 19;
        nArray8[19] = 20;
        nArray8[20] = 21;
        nArray8[21] = 22;
        WELL_KNOWN_PARAMETER_ID_WSP_14 = nArray8;
        PARAMETER_TYPES = new int[]{6, 10, 7, 3, -1, 9, 9, 11, 12, 13, 9, 9, 9, 9, 5, 9, 1, 12, 2, 4, 4, 4, 3, 2, 2, 2, 2, 2, 2, 2};
        wspHeaders_ = new HashMap<String, Integer>();
        wspHeaders_.put("accept", 0);
        wspHeaders_.put("accept-charset", 1);
        wspHeaders_.put("accept-encoding", 2);
        wspHeaders_.put("accept-language", 3);
        wspHeaders_.put("accept-ranges", 4);
        wspHeaders_.put("age", 5);
        wspHeaders_.put("allow", 6);
        wspHeaders_.put("authorization", 7);
        wspHeaders_.put("cache-control", 8);
        wspHeaders_.put("connection", 9);
        wspHeaders_.put("content-base", 10);
        wspHeaders_.put("content-encoding", 11);
        wspHeaders_.put("content-language", 12);
        wspHeaders_.put("content-length", 13);
        wspHeaders_.put("content-location", 14);
        wspHeaders_.put("content-md5", 15);
        wspHeaders_.put("content-range", 16);
        wspHeaders_.put("content-type", 17);
        wspHeaders_.put("date", 18);
        wspHeaders_.put("etag", 19);
        wspHeaders_.put("expires", 20);
        wspHeaders_.put("from", 21);
        wspHeaders_.put("host", 22);
        wspHeaders_.put("if-modified-since", 23);
        wspHeaders_.put("if-match", 24);
        wspHeaders_.put("if-none-match", 25);
        wspHeaders_.put("if-range", 26);
        wspHeaders_.put("if-unmodified-since", 27);
        wspHeaders_.put("location", 29);
        wspHeaders_.put("last-modified", 28);
        wspHeaders_.put("max-forwards", 30);
        wspHeaders_.put("pragma", 31);
        wspHeaders_.put("proxy-authenticate", 32);
        wspHeaders_.put("proxy-authorization", 33);
        wspHeaders_.put("public", 34);
        wspHeaders_.put("range", 35);
        wspHeaders_.put("referer", 36);
        wspHeaders_.put("retry-after", 37);
        wspHeaders_.put("server", 38);
        wspHeaders_.put("transfer-encoding", 39);
        wspHeaders_.put("upgrade", 40);
        wspHeaders_.put("user-agent", 41);
        wspHeaders_.put("vary", 42);
        wspHeaders_.put("via", 43);
        wspHeaders_.put("warning", 44);
        wspHeaders_.put("www-authenticate", 45);
        wspHeaders_.put("content-disposition", 46);
        wspHeaders_.put("accept", 0);
        wspHeaders_.put("x-wap-application-id", 47);
        wspHeaders_.put("x-wap-content-uri", 48);
        wspHeaders_.put("x-wap-initiator-uri", 49);
        wspHeaders_.put("bearer-indication", 51);
        wspHeaders_.put("accept-application", 50);
        wspHeaders_.put("push-flag", 52);
        wspHeaders_.put("profile", 53);
        wspHeaders_.put("profile-diff", 54);
        wspHeaders_.put("profile-warning", 55);
        wspHeaders_.put("expect", 56);
        wspHeaders_.put("te", 57);
        wspHeaders_.put("trailer", 58);
        wspHeaders_.put("accept-charset", 1);
        wspHeaders_.put("accept-encoding", 2);
        wspHeaders_.put("cache-control", 8);
        wspHeaders_.put("content-range", 16);
        wspHeaders_.put("x-wap-tod", 59);
        wspHeaders_.put("content-id", 60);
        wspHeaders_.put("set-cookie", 61);
        wspHeaders_.put("cookie", 62);
        wspHeaders_.put("encoding-version", 63);
        wspHeaders_.put("profile-warning", 55);
        wspHeaders_.put("content-disposition", 46);
        wspHeaders_.put("x-wap-security", 64);
        wspHeaders_.put("cache-control", 8);
        wspContentTypes_ = new HashMap<String, Integer>();
        wspContentTypes_.put("*/*", 0);
        wspContentTypes_.put("text/*", 1);
        wspContentTypes_.put("text/html", 2);
        wspContentTypes_.put("text/plain", 3);
        wspContentTypes_.put("text/x-hdml", 4);
        wspContentTypes_.put("text/x-ttml", 5);
        wspContentTypes_.put("text/x-vCalendar", 6);
        wspContentTypes_.put("text/x-vCard", 7);
        wspContentTypes_.put("text/vnd.wap.wml", 8);
        wspContentTypes_.put("text/vnd.wap.wmlscript", 9);
        wspContentTypes_.put("text/vnd.wap.wta-event", 10);
        wspContentTypes_.put("multipart/*", 11);
        wspContentTypes_.put("multipart/mixed", 12);
        wspContentTypes_.put("multipart/form-data", 13);
        wspContentTypes_.put("multipart/byteranges", 14);
        wspContentTypes_.put("multipart/alternative", 15);
        wspContentTypes_.put("application/*", 16);
        wspContentTypes_.put("application/java-vm", 17);
        wspContentTypes_.put("application/x-www-form-urlencoded", 18);
        wspContentTypes_.put("application/x-hdmlc", 19);
        wspContentTypes_.put("application/vnd.wap.wmlc", 20);
        wspContentTypes_.put("application/vnd.wap.wmlscriptc", 21);
        wspContentTypes_.put("application/vnd.wap.wta-eventc", 22);
        wspContentTypes_.put("application/vnd.wap.uaprof", 23);
        wspContentTypes_.put("application/vnd.wap.wtls-ca-certificate", 24);
        wspContentTypes_.put("application/vnd.wap.wtls-user-certificate", 25);
        wspContentTypes_.put("application/x-x509-ca-cert", 26);
        wspContentTypes_.put("application/x-x509-user-cert", 27);
        wspContentTypes_.put("image/*", 28);
        wspContentTypes_.put("image/gif", 29);
        wspContentTypes_.put("image/jpeg", 30);
        wspContentTypes_.put("image/tiff", 31);
        wspContentTypes_.put("image/png", 32);
        wspContentTypes_.put("image/vnd.wap.wbmp", 33);
        wspContentTypes_.put("application/vnd.wap.multipart.*", 34);
        wspContentTypes_.put("application/vnd.wap.multipart.mixed", 35);
        wspContentTypes_.put("application/vnd.wap.multipart.form-data", 36);
        wspContentTypes_.put("application/vnd.wap.multipart.byteranges", 37);
        wspContentTypes_.put("application/vnd.wap.multipart.alternative", 38);
        wspContentTypes_.put("application/xml", 39);
        wspContentTypes_.put("text/xml", 40);
        wspContentTypes_.put("application/vnd.wap.wbxml", 41);
        wspContentTypes_.put("application/x-x968-cross-cert", 42);
        wspContentTypes_.put("application/x-x968-ca-cert", 43);
        wspContentTypes_.put("application/x-x968-user-cert", 44);
        wspContentTypes_.put("text/vnd.wap.si", 45);
        wspContentTypes_.put("application/vnd.wap.sic", 46);
        wspContentTypes_.put("text/vnd.wap.sl", 47);
        wspContentTypes_.put("application/vnd.wap.slc", 48);
        wspContentTypes_.put("text/vnd.wap.co", 49);
        wspContentTypes_.put("application/vnd.wap.coc", 50);
        wspContentTypes_.put("application/vnd.wap.multipart.related", 51);
        wspContentTypes_.put("application/vnd.wap.sia", 52);
        wspContentTypes_.put("text/vnd.wap.connectivity-xml", 53);
        wspContentTypes_.put("application/vnd.wap.connectivity-wbxml", 54);
        wspContentTypes_.put("application/pkcs7-mime", 55);
        wspContentTypes_.put("application/vnd.wap.hashed-certificate", 56);
        wspContentTypes_.put("application/vnd.wap.signed-certificate", 57);
        wspContentTypes_.put("application/vnd.wap.cert-response", 58);
        wspContentTypes_.put("application/xhtml+xml", 59);
        wspContentTypes_.put("application/wml+xml", 60);
        wspContentTypes_.put("text/css", 61);
        wspContentTypes_.put("application/vnd.wap.mms-message", 62);
        wspContentTypes_.put("application/vnd.wap.rollover-certificate", 63);
        wspContentTypes_.put("application/vnd.wap.locc+wbxml", 64);
        wspContentTypes_.put("application/vnd.wap.loc+xml", 65);
        wspContentTypes_.put("application/vnd.syncml.dm+wbxml", 66);
        wspContentTypes_.put("application/vnd.syncml.dm+xml", 67);
        wspContentTypes_.put("application/vnd.syncml.notification", 68);
        wspContentTypes_.put("application/vnd.wap.xhtml+xml", 69);
        wspContentTypes_.put("application/vnd.wv.csp.cir", 70);
        wspContentTypes_.put("application/vnd.oma.dd+xml", 71);
        wspContentTypes_.put("application/vnd.oma.drm.message", 72);
        wspContentTypes_.put("application/vnd.oma.drm.content", 73);
        wspContentTypes_.put("application/vnd.oma.drm.rights+xml", 74);
        wspContentTypes_.put("application/vnd.oma.drm.rights+wbxml", 75);
        wspParameters_ = new HashMap<String, Integer>();
        wspParameters_.put("q", 0);
        wspParameters_.put("charset", 1);
        wspParameters_.put("level", 2);
        wspParameters_.put("type", 3);
        wspParameters_.put("name", 4);
        wspParameters_.put("filename", 5);
        wspParameters_.put("differences", 6);
        wspParameters_.put("padding", 7);
        wspParameters_.put("type", 8);
        wspParameters_.put("start", 9);
        wspParameters_.put("start-info", 10);
        wspParameters_.put("comment", 11);
        wspParameters_.put("domain", 12);
        wspParameters_.put("max-age", 13);
        wspParameters_.put("path", 14);
        wspParameters_.put("secure", 15);
        wspParameters_.put("sec", 16);
        wspParameters_.put("mac", 17);
        wspParameters_.put("creation-date", 18);
        wspParameters_.put("modification-date", 19);
        wspParameters_.put("read-date", 20);
        wspParameters_.put("size", 21);
        wspParameters_.put("name", 4);
        wspParameters_.put("filename", 5);
        wspParameters_.put("start", 9);
        wspParameters_.put("start-info", 10);
        wspParameters_.put("comment", 11);
        wspParameters_.put("domain", 12);
        wspParameters_.put("path", 14);
        wspPushAppTypes_ = new HashMap<String, Integer>();
        wspPushAppTypes_.put("x-wap-application:*", 0);
        wspPushAppTypes_.put("x-wap-application:push.sia", 1);
        wspPushAppTypes_.put("x-wap-application:wml.ua", 2);
        wspPushAppTypes_.put("x-wap-application:wta.ua", 3);
        wspPushAppTypes_.put("x-wap-application:mms.ua", 4);
        wspPushAppTypes_.put("x-wap-application:push.syncml", 5);
        wspPushAppTypes_.put("x-wap-application:loc.ua", 6);
        wspPushAppTypes_.put("x-wap-application:syncml.dm", 7);
        wspPushAppTypes_.put("x-wap-application:drm.ua", 8);
        wspPushAppTypes_.put("x-wap-application:emn.ua", 9);
        wspPushAppTypes_.put("x-wap-application:wv.ua", 10);
        wspPushAppTypes_.put("x-wap-microsoft:localcontent.ua", 32768);
        wspPushAppTypes_.put("x-wap-microsoft:imclient.ua ", 32769);
        wspPushAppTypes_.put("x-wap-docomo:imode.mail.ua ", 32770);
        wspPushAppTypes_.put("x-wap-docomo:imode.mr.ua", 32771);
        wspPushAppTypes_.put("x-wap-docomo:imode.mf.ua", 32772);
        wspPushAppTypes_.put("x-motorola:location.ua ", 32773);
        wspPushAppTypes_.put("x-motorola:now.ua", 32774);
        wspPushAppTypes_.put("x-motorola:otaprov.ua", 32775);
        wspPushAppTypes_.put("x-motorola:browser.ua", 32776);
        wspPushAppTypes_.put("x-motorola:splash.ua", 32777);
        wspPushAppTypes_.put("x-wap-nai:mvsw.command ", 32779);
        wspPushAppTypes_.put("x-wap-openwave:iota.ua", 32784);
    }

    private WspUtil() {
    }

    public static int getHeaderType(String headerName) {
        Integer headerType = wspHeaders_.get(headerName);
        return headerType != null ? headerType : -1;
    }

    public static int getWellKnownHeaderId(WspEncodingVersion wspEncodingVersion, int headerType) {
        int wellKnownHeaderId;
        switch (wspEncodingVersion) {
            case VERSION_1_1: {
                wellKnownHeaderId = WELL_KNOWN_HEADER_ID_WSP_11[headerType];
                break;
            }
            case VERSION_1_2: {
                wellKnownHeaderId = WELL_KNOWN_HEADER_ID_WSP_12[headerType];
                break;
            }
            case VERSION_1_3: {
                wellKnownHeaderId = WELL_KNOWN_HEADER_ID_WSP_13[headerType];
                break;
            }
            case VERSION_1_4: 
            case VERSION_1_5: {
                wellKnownHeaderId = WELL_KNOWN_HEADER_ID_WSP_14[headerType];
                break;
            }
            default: {
                wellKnownHeaderId = -1;
            }
        }
        return wellKnownHeaderId;
    }

    public static int getWellKnownContentTypeId(WspEncodingVersion wspEncodingVersion, String contentType) {
        Integer contentTypeIdInt = wspContentTypes_.get(contentType);
        if (contentTypeIdInt == null) {
            return -1;
        }
        int wellKnownContentTypeId = contentTypeIdInt;
        if (wspEncodingVersion.isWellKnownContentTypeId(wellKnownContentTypeId)) {
            return wellKnownContentTypeId;
        }
        return -1;
    }

    public static int getParameterType(String parameterName) {
        Integer parameterType = wspParameters_.get(parameterName);
        return parameterType != null ? parameterType : -1;
    }

    public static int getWspParameterType(int wellKnownParameterId) {
        return PARAMETER_TYPES[wellKnownParameterId];
    }

    public static int getWellKnownParameterId(WspEncodingVersion wspEncodingVersion, int parameterType) {
        int wellKnownParameterId = -1;
        if (parameterType >= 0) {
            switch (wspEncodingVersion) {
                case VERSION_1_1: {
                    wellKnownParameterId = WELL_KNOWN_PARAMETER_ID_WSP_11[parameterType];
                    break;
                }
                case VERSION_1_2: {
                    wellKnownParameterId = WELL_KNOWN_PARAMETER_ID_WSP_12[parameterType];
                    break;
                }
                case VERSION_1_3: {
                    wellKnownParameterId = WELL_KNOWN_PARAMETER_ID_WSP_13[parameterType];
                    break;
                }
                case VERSION_1_4: 
                case VERSION_1_5: {
                    wellKnownParameterId = WELL_KNOWN_PARAMETER_ID_WSP_14[parameterType];
                }
            }
        }
        return wellKnownParameterId;
    }

    public static int getWellKnownPushAppId(String pushApp) {
        Integer pushAppIdInt = wspPushAppTypes_.get(pushApp);
        if (pushAppIdInt == null) {
            return -1;
        }
        return pushAppIdInt;
    }

    public static void writeUint8(OutputStream theOs, int theValue) throws IOException {
        theOs.write(theValue);
    }

    public static void writeUintvar(OutputStream theOs, long theValue) throws IOException {
        int nOctets = 1;
        while (theValue >> 7 * nOctets > 0L) {
            ++nOctets;
        }
        int i = nOctets;
        while (i > 0) {
            byte octet = (byte)(theValue >> 7 * (i - 1));
            byte byteValue = (byte)(octet & 0x7F);
            if (i > 1) {
                byteValue = (byte)(byteValue | 0xFFFFFF80);
            }
            theOs.write(byteValue);
            --i;
        }
    }

    public static void writeLongInteger(OutputStream theOs, long theValue) throws IOException {
        int nOctets = 0;
        while (theValue >> 8 * nOctets > 0L) {
            ++nOctets;
        }
        theOs.write((byte)nOctets);
        int i = nOctets;
        while (i > 0) {
            byte octet = (byte)(theValue >> 8 * (i - 1));
            byte byteValue = (byte)(octet & 0xFFFFFFFF);
            theOs.write(byteValue);
            --i;
        }
    }

    public static void writeInteger(OutputStream theOs, long theValue) throws IOException {
        if (theValue < 128L) {
            WspUtil.writeShortInteger(theOs, (int)theValue);
        } else {
            WspUtil.writeLongInteger(theOs, theValue);
        }
    }

    public static void writeShortInteger(OutputStream theOs, int theValue) throws IOException {
        theOs.write((byte)(theValue | 0xFFFFFF80));
    }

    public static void writeValueLength(OutputStream theOs, long theValue) throws IOException {
        if (theValue <= 30L) {
            theOs.write((int)theValue);
        } else {
            theOs.write(31);
            WspUtil.writeUintvar(theOs, theValue);
        }
    }

    public static void writeExtensionMedia(OutputStream theOs, String theStr) throws IOException {
        theOs.write(theStr.getBytes(StandardCharsets.UTF_8));
        theOs.write(0);
    }

    public static void writeTextString(OutputStream theOs, String theStr) throws IOException {
        byte[] strBytes = theStr.getBytes(StandardCharsets.UTF_8);
        if ((strBytes[0] & 0x80) > 0) {
            theOs.write(127);
        }
        theOs.write(strBytes);
        theOs.write(0);
    }

    public static void writeQuotedString(OutputStream theOs, String theStr) throws IOException {
        theOs.write(34);
        theOs.write(theStr.getBytes(StandardCharsets.UTF_8));
        theOs.write(0);
    }

    public static void writeTokenText(OutputStream theOs, String theStr) throws IOException {
        theOs.write(theStr.getBytes(StandardCharsets.UTF_8));
        theOs.write(0);
    }

    public static void writeTextValue(OutputStream theOs, String theStr) throws IOException {
        WspUtil.writeQuotedString(theOs, theStr);
    }

    public static void writeContentType(WspEncodingVersion wspEncodingVersion, OutputStream theOs, String theContentType) throws IOException {
        int wellKnownContentType = WspUtil.getWellKnownContentTypeId(wspEncodingVersion, theContentType.toLowerCase());
        if (wellKnownContentType == -1) {
            WspUtil.writeValueLength(theOs, theContentType.length() + 1);
            WspUtil.writeExtensionMedia(theOs, theContentType);
        } else {
            WspUtil.writeShortInteger(theOs, wellKnownContentType);
        }
    }

    public static void writeContentType(WspEncodingVersion wspEncodingVersion, OutputStream theOs, MimeHeader theContentType) throws IOException {
        if (theContentType.getParameters().isEmpty()) {
            WspUtil.writeContentType(wspEncodingVersion, theOs, theContentType.getValue());
        } else {
            String theContentTypeStr = theContentType.getValue();
            int wellKnownContentType = WspUtil.getWellKnownContentTypeId(wspEncodingVersion, theContentTypeStr.toLowerCase());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (wellKnownContentType == -1) {
                WspUtil.writeExtensionMedia(baos, theContentType.getValue());
            } else {
                WspUtil.writeInteger(baos, wellKnownContentType);
            }
            for (MimeHeaderParameter headerParam : theContentType.getParameters()) {
                WspUtil.writeParameter(wspEncodingVersion, baos, headerParam.getName(), headerParam.getValue());
            }
            baos.close();
            WspUtil.writeValueLength(theOs, baos.size());
            theOs.write(baos.toByteArray());
        }
    }

    public static void writeTypedValue(WspEncodingVersion wspEncodingVersion, OutputStream os, int wspParamType, String value) throws IOException {
        switch (wspParamType) {
            case 1: {
                os.write(0);
                break;
            }
            case 2: {
                WspUtil.writeTextValue(os, value);
                break;
            }
            case 3: {
                WspUtil.writeInteger(os, Long.parseLong(value));
                break;
            }
            case 4: {
                Long l = Long.valueOf(value);
                WspUtil.writeLongInteger(os, l);
                break;
            }
            case 5: {
                Integer i = Integer.valueOf(value);
                WspUtil.writeInteger(os, i.intValue());
                break;
            }
            case 6: {
                WspUtil.writeTextString(os, value);
                break;
            }
            case 7: {
                WspUtil.writeTextString(os, value);
                break;
            }
            case 8: {
                WspUtil.writeTextString(os, value);
                break;
            }
            case 9: {
                WspUtil.writeTextString(os, value);
                break;
            }
            case 10: {
                WspUtil.writeInteger(os, 106L);
                break;
            }
            case 11: {
                WspUtil.writeTextString(os, value);
                break;
            }
            case 12: {
                WspUtil.writeShortInteger(os, Integer.parseInt(value));
                break;
            }
            case 13: {
                WspUtil.writeContentType(wspEncodingVersion, os, value);
                break;
            }
            default: {
                WspUtil.writeTextString(os, value);
            }
        }
    }

    public static void writeParameter(WspEncodingVersion wspEncodingVersion, OutputStream os, String name, String value) throws IOException {
        int parameterType = WspUtil.getParameterType(name);
        int wellKnownParameter = WspUtil.getWellKnownParameterId(wspEncodingVersion, parameterType);
        if (wellKnownParameter == -1) {
            WspUtil.writeTokenText(os, name);
            WspUtil.writeTextString(os, value);
        } else {
            WspUtil.writeInteger(os, wellKnownParameter);
            WspUtil.writeTypedValue(wspEncodingVersion, os, WspUtil.getWspParameterType(wellKnownParameter), value);
        }
    }

    public static String convertMultipartContentType(String ct) {
        if (ct.equalsIgnoreCase("multipart/*")) {
            return "application/vnd.wap.multipart.*";
        }
        if (ct.equalsIgnoreCase("multipart/mixed")) {
            return "application/vnd.wap.multipart.mixed";
        }
        if (ct.equalsIgnoreCase("multipart/form-data")) {
            return "application/vnd.wap.multipart.form-data";
        }
        if (ct.equalsIgnoreCase("multipart/byteranges")) {
            return "application/vnd.wap.multipart.byteranges";
        }
        if (ct.equalsIgnoreCase("multipart/alternative")) {
            return "application/vnd.wap.multipart.alternative";
        }
        if (ct.equalsIgnoreCase("multipart/related")) {
            return "application/vnd.wap.multipart.related";
        }
        return ct;
    }
}

