/*
 * Decompiled with CFR 0.152.
 */
package org.marre.wap.mms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.marre.mime.MimeHeader;
import org.marre.util.StringUtil;
import org.marre.wap.WspEncodingVersion;
import org.marre.wap.WspUtil;
import org.marre.wap.mms.MmsConstants;

public final class MmsHeaderEncoder {
    private MmsHeaderEncoder() {
    }

    public static void writeHeaderContentLocation(OutputStream os, String contentLocation) throws IOException {
        WspUtil.writeShortInteger(os, 3);
        WspUtil.writeTextString(os, contentLocation);
    }

    public static void writeHeaderContentType(WspEncodingVersion wspEncodingVersion, OutputStream os, String contentLocation) throws IOException {
        WspUtil.writeShortInteger(os, 4);
        WspUtil.writeContentType(wspEncodingVersion, os, contentLocation);
    }

    public static void writeHeaderContentType(WspEncodingVersion wspEncodingVersion, OutputStream os, MimeHeader contentType) throws IOException {
        WspUtil.writeShortInteger(os, 4);
        WspUtil.writeContentType(wspEncodingVersion, os, contentType);
    }

    public static void writeEncodedStringValue(OutputStream os, String stringValue) throws IOException {
        WspUtil.writeTextString(os, stringValue);
    }

    public static void writeHeaderXMmsMessageType(OutputStream os, int messageTypeId) throws IOException {
        WspUtil.writeShortInteger(os, 12);
        WspUtil.writeShortInteger(os, messageTypeId);
    }

    public static void writeHeaderXMmsMessageType(OutputStream os, String messageType) throws IOException {
        int messageTypeId = StringUtil.findString(MmsConstants.X_MMS_MESSAGE_TYPE_NAMES, messageType.toLowerCase());
        if (messageTypeId != -1) {
            MmsHeaderEncoder.writeHeaderXMmsMessageType(os, messageTypeId);
        }
    }

    public static void writeHeaderXMmsTransactionId(OutputStream os, String transactionId) throws IOException {
        WspUtil.writeShortInteger(os, 24);
        WspUtil.writeTextString(os, transactionId);
    }

    public static void writeHeaderXMmsMmsVersion(OutputStream os, int version) throws IOException {
        WspUtil.writeShortInteger(os, 13);
        WspUtil.writeShortInteger(os, version);
    }

    public static void writeHeaderDate(OutputStream os, Date date) throws IOException {
        WspUtil.writeShortInteger(os, 5);
        long time = date.getTime() / 1000L;
        WspUtil.writeLongInteger(os, time);
    }

    public static void writeHeaderFrom(OutputStream os, String from) throws IOException {
        WspUtil.writeShortInteger(os, 9);
        if (from == null) {
            from = "Unknow";
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            WspUtil.writeShortInteger(baos, 0);
            MmsHeaderEncoder.writeEncodedStringValue(baos, from);
            baos.close();
            WspUtil.writeValueLength(os, baos.size());
            os.write(baos.toByteArray());
        }
    }

    public static void writeHeaderSubject(OutputStream os, String subject) throws IOException {
        WspUtil.writeShortInteger(os, 22);
        MmsHeaderEncoder.writeEncodedStringValue(os, subject);
    }

    public static void writeHeaderMessageId(OutputStream os, String message) throws IOException {
        WspUtil.writeShortInteger(os, 11);
        MmsHeaderEncoder.writeEncodedStringValue(os, message);
    }

    public static void writeHeaderTo(OutputStream os, String receiver) throws IOException {
        WspUtil.writeShortInteger(os, 23);
        MmsHeaderEncoder.writeEncodedStringValue(os, receiver);
    }

    public static void writeHeaderCc(OutputStream os, String receiver) throws IOException {
        WspUtil.writeShortInteger(os, 2);
        MmsHeaderEncoder.writeEncodedStringValue(os, receiver);
    }

    public static void writeHeaderBcc(OutputStream os, String receiver) throws IOException {
        WspUtil.writeShortInteger(os, 1);
        MmsHeaderEncoder.writeEncodedStringValue(os, receiver);
    }

    public static void writeHeaderXMmsReadReply(OutputStream os, int readReplyId) throws IOException {
        WspUtil.writeShortInteger(os, 16);
        WspUtil.writeShortInteger(os, readReplyId);
    }

    public static void writeHeaderXMmsReadReply(OutputStream os, String readReply) throws IOException {
        int readReplyId = StringUtil.findString(MmsConstants.X_MMS_READ_REPLY_NAMES, readReply.toLowerCase());
        if (readReplyId != -1) {
            MmsHeaderEncoder.writeHeaderXMmsReadReply(os, readReplyId);
        }
    }

    public static void writeHeaderXMmsPriority(OutputStream os, int priorityId) throws IOException {
        WspUtil.writeShortInteger(os, 15);
        WspUtil.writeShortInteger(os, priorityId);
    }

    public static void writeHeaderXMmsPriority(OutputStream os, String priority_) throws IOException {
        int priorityId = StringUtil.findString(MmsConstants.X_MMS_PRIORITY_NAMES, priority_.toLowerCase());
        if (priorityId != -1) {
            MmsHeaderEncoder.writeHeaderXMmsPriority(os, priorityId);
        }
    }

    public static void writeHeaderXMmsStatus(OutputStream os, int status) throws IOException {
        WspUtil.writeShortInteger(os, 21);
        WspUtil.writeShortInteger(os, status);
    }

    public static void writeHeaderXMmsStatus(OutputStream os, String status) throws IOException {
        int statusId = StringUtil.findString(MmsConstants.X_MMS_STATUS_NAMES, status.toLowerCase());
        if (statusId != -1) {
            MmsHeaderEncoder.writeHeaderXMmsStatus(os, statusId);
        }
    }

    public static void writeHeaderXMmsMessageClass(OutputStream os, int messageClassId) throws IOException {
        WspUtil.writeShortInteger(os, 10);
        WspUtil.writeShortInteger(os, messageClassId);
    }

    public static void writeHeaderXMmsMessageClass(OutputStream os, String messageClass) throws IOException {
        int messageClassId = StringUtil.findString(MmsConstants.X_MMS_MESSAGE_CLASS_NAMES, messageClass.toLowerCase());
        if (messageClassId != -1) {
            MmsHeaderEncoder.writeHeaderXMmsMessageClass(os, messageClassId);
        }
    }

    public static void writeHeaderXMmsMessageSize(OutputStream os, long messageSize) throws IOException {
        WspUtil.writeShortInteger(os, 14);
        WspUtil.writeLongInteger(os, messageSize);
    }

    public static void writeHeaderXMmsExpiryAbsolute(OutputStream os, long expiry) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        WspUtil.writeShortInteger(baos, 0);
        WspUtil.writeLongInteger(baos, expiry);
        baos.close();
        WspUtil.writeShortInteger(os, 8);
        WspUtil.writeValueLength(os, baos.size());
        os.write(baos.toByteArray());
    }

    public static void writeHeaderXMmsExpiryAbsolute(OutputStream os, Date expiry) throws IOException {
        MmsHeaderEncoder.writeHeaderXMmsExpiryAbsolute(os, expiry.getTime());
    }

    public static void writeHeaderXMmsExpiryRelative(OutputStream os, long expiry) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        WspUtil.writeShortInteger(baos, 1);
        WspUtil.writeLongInteger(baos, expiry);
        baos.close();
        WspUtil.writeShortInteger(os, 8);
        WspUtil.writeValueLength(os, baos.size());
        os.write(baos.toByteArray());
    }

    public static void writeHeaderXMmsSenderVisibility(OutputStream os, int visibilityId) throws IOException {
        WspUtil.writeShortInteger(os, 20);
        WspUtil.writeShortInteger(os, visibilityId);
    }

    public static void writeHeaderXMmsSenderVisibility(OutputStream os, String newVisabilityId) throws IOException {
        int visibilityId = StringUtil.findString(MmsConstants.X_MMS_SENDER_VISIBILITY_NAMES, newVisabilityId.toLowerCase());
        if (visibilityId != -1) {
            MmsHeaderEncoder.writeHeaderXMmsSenderVisibility(os, visibilityId);
        }
    }

    public static void writeApplicationHeader(OutputStream os, String name, String value) throws IOException {
        WspUtil.writeTokenText(os, name);
        WspUtil.writeTextString(os, value);
    }
}

