/*
 * Decompiled with CFR 0.152.
 */
package org.marre.wap.push;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.marre.mime.MimeBodyPart;
import org.marre.sms.SmsUserData;
import org.marre.util.StringUtil;
import org.marre.wap.mms.MmsHeaderEncoder;
import org.marre.wap.push.SmsWapPushMessage;

public class SmsMmsNotificationMessage
extends SmsWapPushMessage
implements Serializable {
    private static final long serialVersionUID = 3659719878719271285L;
    private static final int DEFAULT_TRANSACTION_ID_LENGTH = 5;
    private static final long DEFAULT_EXPIRY = 259200L;
    protected String transactionId_ = "";
    protected String from_ = "";
    protected String subject_ = "";
    protected int messageClassId_ = 0;
    protected final long size_;
    protected long expiry_ = 172800L;
    protected final String contentLocation_;

    public SmsMmsNotificationMessage(String contentLocation, long size) {
        this.contentLocation_ = contentLocation;
        this.transactionId_ = StringUtil.randString(5);
        this.expiry_ = 259200L;
        this.size_ = size;
    }

    protected void writeNotificationTo(OutputStream os) throws IOException {
        MmsHeaderEncoder.writeHeaderXMmsMessageType(os, 2);
        MmsHeaderEncoder.writeHeaderXMmsTransactionId(os, this.transactionId_);
        MmsHeaderEncoder.writeHeaderXMmsMmsVersion(os, 18);
        MmsHeaderEncoder.writeHeaderContentLocation(os, this.contentLocation_);
        MmsHeaderEncoder.writeHeaderXMmsExpiryRelative(os, this.expiry_);
        if (this.subject_ != null && this.subject_.length() > 0) {
            MmsHeaderEncoder.writeHeaderSubject(os, this.subject_);
        }
        if (this.from_ != null && this.from_.length() > 0) {
            MmsHeaderEncoder.writeHeaderFrom(os, this.from_);
        }
        MmsHeaderEncoder.writeHeaderXMmsMessageClass(os, this.messageClassId_);
        MmsHeaderEncoder.writeHeaderXMmsMessageSize(os, this.size_);
    }

    public void setMessageClass(int messageClassId) {
        this.messageClassId_ = messageClassId;
    }

    public void setSubject(String subject) {
        this.subject_ = subject;
    }

    public void setExpiry(int i) {
        this.expiry_ = i;
    }

    public void setFrom(String string) {
        this.from_ = string;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId_ = transactionId;
    }

    @Override
    public SmsUserData getUserData() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
        try {
            this.writeNotificationTo(baos);
            baos.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        this.pushMsg_ = new MimeBodyPart(baos.toByteArray(), "application/vnd.wap.mms-message");
        this.setXWapApplicationId("x-wap-application:mms.ua");
        return super.getUserData();
    }

    public String getTransactionId_() {
        return this.transactionId_;
    }

    public String getFrom_() {
        return this.from_;
    }

    public String getSubject_() {
        return this.subject_;
    }

    public int getMessageClassId_() {
        return this.messageClassId_;
    }

    public long getSize_() {
        return this.size_;
    }

    public long getExpiry_() {
        return this.expiry_;
    }

    public String getContentLocation_() {
        return this.contentLocation_;
    }

    @Override
    public String toString() {
        return this.getContentLocation_();
    }
}

