/*
 * Decompiled with CFR 0.152.
 */
package org.marre.wap.push;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.marre.mime.MimeBodyPart;
import org.marre.mime.MimeContentType;
import org.marre.sms.SmsPort;
import org.marre.sms.SmsPortAddressedMessage;
import org.marre.sms.SmsUserData;
import org.marre.wap.WapMimeEncoder;
import org.marre.wap.WspEncodingVersion;
import org.marre.wap.WspUtil;
import org.marre.wap.push.WapSIPush;
import org.marre.wap.push.WapSLPush;
import org.marre.wap.wbxml.WbxmlDocument;

public class SmsWapPushMessage
extends SmsPortAddressedMessage
implements Serializable {
    private static final long serialVersionUID = 3377585301993184604L;
    protected WspEncodingVersion wspEncodingVersion_ = WspEncodingVersion.VERSION_1_3;
    protected transient MimeBodyPart pushMsg_;
    private WbxmlDocument wbxml;

    protected SmsWapPushMessage() {
        super(SmsPort.WAP_PUSH, SmsPort.WAP_WSP);
    }

    public SmsWapPushMessage(MimeBodyPart pushMsg) {
        this();
        this.pushMsg_ = pushMsg;
    }

    public SmsWapPushMessage(WbxmlDocument pushMsg, MimeContentType contentType) {
        this();
        contentType.setParam("charset", "utf-8");
        this.wbxml = pushMsg;
        this.pushMsg_ = new MimeBodyPart(this.buildPushMessage(pushMsg), contentType);
    }

    public SmsWapPushMessage(WbxmlDocument pushMsg, String contentType) {
        this(pushMsg, new MimeContentType(contentType));
    }

    public SmsWapPushMessage(WbxmlDocument pushMsg) {
        this(pushMsg, pushMsg.getWbxmlContentType());
    }

    public SmsWapPushMessage(byte[] pushMsg, MimeContentType contentType) {
        this();
        this.pushMsg_ = new MimeBodyPart(pushMsg, contentType);
    }

    public SmsWapPushMessage(byte[] pushMsg, String contentType) {
        this();
        this.pushMsg_ = new MimeBodyPart(pushMsg, contentType);
    }

    protected byte[] buildPushMessage(WbxmlDocument pushMsg) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            pushMsg.writeXmlTo(pushMsg.getWbxmlWriter(baos));
            baos.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return baos.toByteArray();
    }

    public void setWspEncodingVersion(WspEncodingVersion wspEncodingVersion) {
        this.wspEncodingVersion_ = wspEncodingVersion;
    }

    @Override
    public SmsUserData getUserData() {
        WapMimeEncoder wapMimeEncoder = new WapMimeEncoder(WspEncodingVersion.VERSION_1_3);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            WspUtil.writeUint8(baos, 0);
            WspUtil.writeUint8(baos, 6);
            ByteArrayOutputStream headers = new ByteArrayOutputStream();
            wapMimeEncoder.writeContentType(headers, this.pushMsg_);
            wapMimeEncoder.writeHeaders(headers, this.pushMsg_);
            headers.close();
            WspUtil.writeUintvar(baos, headers.size());
            baos.write(headers.toByteArray());
            wapMimeEncoder.writeBody(baos, this.pushMsg_);
            baos.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return new SmsUserData(baos.toByteArray());
    }

    public void setXWapApplicationId(String appId) {
        this.pushMsg_.addHeader("X-Wap-Application-Id", appId);
    }

    public void setXWapContentURI(String contentUri) {
        this.pushMsg_.addHeader("X-Wap-Content-URI", contentUri);
    }

    public void setXWapInitiatorURI(String initiatorUri) {
        this.pushMsg_.addHeader("X-Wap-Initiator-URI", initiatorUri);
    }

    public WbxmlDocument getWbxml() {
        return this.wbxml;
    }

    public void setWbxml(WbxmlDocument wbxml) {
        this.wbxml = wbxml;
    }

    public String toString() {
        WbxmlDocument wbxml = this.getWbxml();
        if (wbxml instanceof WapSIPush) {
            return ((WapSIPush)wbxml).getUri();
        }
        if (wbxml instanceof WapSLPush) {
            return ((WapSLPush)wbxml).getUri();
        }
        return wbxml.toString();
    }
}

