/*
 * Decompiled with CFR 0.152.
 */
package org.marre.wap.wbxml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.marre.util.StringUtil;
import org.marre.wap.WspUtil;
import org.marre.wap.wbxml.WbxmlConstants;
import org.marre.xml.XmlAttribute;
import org.marre.xml.XmlWriter;

public class WbxmlWriter
implements XmlWriter {
    private final Map<String, Integer> stringTable_ = new HashMap<String, Integer>();
    private final ByteArrayOutputStream stringTableBuf_ = new ByteArrayOutputStream();
    private final OutputStream os_;
    private final ByteArrayOutputStream wbxmlBody_ = new ByteArrayOutputStream();
    private String[] tagTokens_;
    private String[] attrStartTokens_;
    private String[] attrValueTokens_;
    private String publicID_;

    public WbxmlWriter(OutputStream os, String[] tagTokens, String[] attrStrartTokens, String[] attrValueTokens) {
        this.os_ = os;
        this.setTagTokens(tagTokens);
        this.setAttrStartTokens(attrStrartTokens);
        this.setAttrValueTokens(attrValueTokens);
    }

    public WbxmlWriter(OutputStream os) {
        this(os, null, null, null);
    }

    @Override
    public void flush() throws IOException {
        WspUtil.writeUint8(this.os_, 1);
        this.writePublicIdentifier(this.os_, this.publicID_);
        WspUtil.writeUintvar(this.os_, 106L);
        this.writeStringTable(this.os_);
        this.wbxmlBody_.close();
        this.wbxmlBody_.writeTo(this.os_);
        this.os_.flush();
    }

    @Override
    public void setDoctype(String name, String systemURI) {
        this.publicID_ = null;
    }

    @Override
    public void setDoctype(String name, String publicID, String publicURI) {
        this.publicID_ = publicID;
    }

    @Override
    public void setDoctype(String publicID) {
        this.publicID_ = publicID;
    }

    @Override
    public void addStartElement(String tag) throws IOException {
        int tagIndex = StringUtil.findString(this.tagTokens_, tag);
        if (tagIndex >= 0) {
            this.wbxmlBody_.write(0x40 | (tagIndex += 5));
        } else {
            this.wbxmlBody_.write(68);
            this.writeStrT(this.wbxmlBody_, tag);
        }
    }

    @Override
    public void addStartElement(String tag, XmlAttribute[] attribs) throws IOException {
        int tagIndex = StringUtil.findString(this.tagTokens_, tag);
        if (tagIndex >= 0) {
            this.wbxmlBody_.write(0xFFFFFFC0 | (tagIndex += 5));
        } else if (tag != null) {
            this.wbxmlBody_.write(-60);
            this.writeStrT(this.wbxmlBody_, tag);
        }
        this.writeAttributes(this.wbxmlBody_, attribs);
    }

    @Override
    public void addEmptyElement(String tag) throws IOException {
        int tagIndex = StringUtil.findString(this.tagTokens_, tag);
        if (tagIndex >= 0) {
            this.wbxmlBody_.write(0 | (tagIndex += 5));
        } else if (tag != null) {
            this.wbxmlBody_.write(4);
            this.writeStrT(this.wbxmlBody_, tag);
        }
    }

    @Override
    public void addEmptyElement(String tag, XmlAttribute[] attribs) throws IOException {
        int tagIndex = StringUtil.findString(this.tagTokens_, tag);
        if (tagIndex >= 0) {
            this.wbxmlBody_.write(0xFFFFFF80 | (tagIndex += 5));
        } else {
            this.wbxmlBody_.write(-124);
            this.writeStrT(this.wbxmlBody_, tag);
        }
        this.writeAttributes(this.wbxmlBody_, attribs);
    }

    @Override
    public void addEndElement() {
        this.wbxmlBody_.write(1);
    }

    @Override
    public void addCharacters(char[] ch, int start, int length) throws IOException {
        this.addCharacters(new String(ch, start, length));
    }

    @Override
    public void addCharacters(String str) throws IOException {
        this.wbxmlBody_.write(3);
        this.writeStrI(this.wbxmlBody_, str);
    }

    public void addOpaqueData(byte[] buff) throws IOException {
        this.addOpaqueData(buff, 0, buff.length);
    }

    public void addOpaqueData(byte[] buff, int off, int len) throws IOException {
        this.wbxmlBody_.write(-61);
        WspUtil.writeUintvar(this.wbxmlBody_, buff.length);
        this.wbxmlBody_.write(buff, off, len);
    }

    public void setTagTokens(String[] tagTokens) {
        if (tagTokens != null) {
            this.tagTokens_ = new String[tagTokens.length];
            System.arraycopy(tagTokens, 0, this.tagTokens_, 0, tagTokens.length);
        } else {
            this.tagTokens_ = null;
        }
    }

    public void setAttrStartTokens(String[] attrStrartTokens) {
        if (attrStrartTokens != null) {
            this.attrStartTokens_ = new String[attrStrartTokens.length];
            System.arraycopy(attrStrartTokens, 0, this.attrStartTokens_, 0, attrStrartTokens.length);
        } else {
            this.attrStartTokens_ = null;
        }
    }

    public void setAttrValueTokens(String[] attrValueTokens) {
        if (attrValueTokens != null) {
            this.attrValueTokens_ = new String[attrValueTokens.length];
            System.arraycopy(attrValueTokens, 0, this.attrValueTokens_, 0, attrValueTokens.length);
        } else {
            this.attrValueTokens_ = null;
        }
    }

    private void writePublicIdentifier(OutputStream os, String publicID) throws IOException {
        if (publicID == null) {
            WspUtil.writeUintvar(os, 1L);
        } else {
            int idx = StringUtil.findString(WbxmlConstants.KNOWN_PUBLIC_DOCTYPES, publicID);
            if (idx != -1) {
                WspUtil.writeUintvar(os, idx += 2);
            } else {
                WspUtil.writeUintvar(os, 0L);
                this.writeStrT(os, publicID);
            }
        }
    }

    private void writeStrI(OutputStream os, String str) throws IOException {
        if (str != null) {
            os.write(str.getBytes("UTF-8"));
            os.write(0);
        }
    }

    private void writeStrT(OutputStream os, String str) throws IOException {
        Integer index = this.stringTable_.get(str);
        if (index == null) {
            index = new Integer(this.stringTableBuf_.size());
            this.stringTable_.put(str, index);
            this.writeStrI(this.stringTableBuf_, str);
        }
        WspUtil.writeUintvar(os, index.intValue());
    }

    private void writeStringTable(OutputStream os) throws IOException {
        WspUtil.writeUintvar(os, this.stringTableBuf_.size());
        this.stringTableBuf_.writeTo(os);
    }

    private void writeAttributes(OutputStream os, XmlAttribute[] attribs) throws IOException {
        XmlAttribute[] xmlAttributeArray = attribs;
        int n = attribs.length;
        int n2 = 0;
        while (n2 < n) {
            XmlAttribute attrib = xmlAttributeArray[n2];
            String typeValue = String.valueOf(attrib.getType()) + "=" + attrib.getValue();
            int idx = StringUtil.findString(this.attrStartTokens_, typeValue);
            if (idx >= 0) {
                this.wbxmlBody_.write(idx += 5);
            } else {
                idx = StringUtil.findString(this.attrStartTokens_, attrib.getType());
                if (idx >= 0) {
                    this.wbxmlBody_.write(idx += 5);
                } else {
                    this.wbxmlBody_.write(4);
                    this.writeStrT(this.wbxmlBody_, attrib.getType());
                }
                String attrValue = attrib.getValue();
                if (attrValue != null && !attrValue.equals("")) {
                    idx = StringUtil.findString(this.attrValueTokens_, attrValue);
                    if (idx >= 0) {
                        this.wbxmlBody_.write(idx += 133);
                    } else {
                        this.wbxmlBody_.write(3);
                        this.writeStrI(this.wbxmlBody_, attrValue);
                    }
                }
            }
            ++n2;
        }
        this.wbxmlBody_.write(1);
    }
}

