/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.logger.db;

import com.alibaba.fastjson.JSON;
import com.codingapi.txlcn.logger.db.LogDbProperties;
import com.codingapi.txlcn.logger.exception.TxLoggerException;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class LogDbHelper
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(LogDbHelper.class);
    private HikariDataSource hikariDataSource;
    private QueryRunner queryRunner;

    public LogDbHelper(LogDbProperties logDbProperties) throws TxLoggerException {
        log.info("log-db Properties: {}", (Object)JSON.toJSONString((Object)((Object)logDbProperties)));
        if (logDbProperties.getDriverClassName() == null) {
            throw new TxLoggerException("Init TxLogger error. see config [com.codingapi.txlcn.logger.db.LogDbProperties]");
        }
        this.hikariDataSource = new HikariDataSource((HikariConfig)logDbProperties);
        this.queryRunner = new QueryRunner((DataSource)this.hikariDataSource);
        log.info("log-db prepared.");
    }

    public int update(String sql, Object ... params) {
        try {
            return this.queryRunner.update(sql, params);
        }
        catch (SQLException e) {
            log.error("update error", (Throwable)e);
            return 0;
        }
    }

    public <T> T query(String sql, ResultSetHandler<T> rsh, Object ... params) {
        try {
            return (T)this.queryRunner.query(sql, rsh, params);
        }
        catch (SQLException e) {
            log.error("query error", (Throwable)e);
            return null;
        }
    }

    public <T> T query(String sql, ScalarHandler<T> scalarHandler, Object ... params) {
        try {
            return (T)this.queryRunner.query(sql, scalarHandler, params);
        }
        catch (SQLException e) {
            log.error("query error", (Throwable)e);
            return null;
        }
    }

    public void destroy() throws Exception {
        this.hikariDataSource.close();
        log.info("log hikariDataSource close.");
    }
}

