/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tm.core;

import com.codingapi.txlcn.common.exception.FastStorageException;
import com.codingapi.txlcn.common.exception.TransactionException;
import com.codingapi.txlcn.tm.core.DTXContext;
import com.codingapi.txlcn.tm.core.DTXContextRegistry;
import com.codingapi.txlcn.tm.core.DefaultDTXContext;
import com.codingapi.txlcn.tm.core.storage.FastStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultDTXContextRegistry
implements DTXContextRegistry {
    private final FastStorage fastStorage;

    @Autowired
    public DefaultDTXContextRegistry(FastStorage fastStorage) {
        this.fastStorage = fastStorage;
    }

    @Override
    public DTXContext create(String groupId) throws TransactionException {
        block2: {
            try {
                this.fastStorage.initGroup(groupId);
            }
            catch (FastStorageException e) {
                if (e.getCode() == 100) break block2;
                throw new TransactionException((Throwable)e);
            }
        }
        return this.get(groupId);
    }

    @Override
    public DTXContext get(String groupId) throws TransactionException {
        return new DefaultDTXContext(groupId, this.fastStorage);
    }

    @Override
    public void destroyContext(String groupId) {
        try {
            this.fastStorage.clearGroup(groupId);
        }
        catch (FastStorageException e) {
            if (e.getCode() == 101) {
                return;
            }
            try {
                this.fastStorage.clearGroup(groupId);
            }
            catch (FastStorageException e1) {
                throw new IllegalStateException(e1);
            }
        }
    }

    @Override
    public int transactionState(String groupId) {
        try {
            return this.fastStorage.getTransactionState(groupId);
        }
        catch (FastStorageException e) {
            return -1;
        }
    }
}

