/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tm.core;

import com.codingapi.txlcn.common.exception.TransactionException;
import com.codingapi.txlcn.logger.TxLogger;
import com.codingapi.txlcn.tm.core.DTXContext;
import com.codingapi.txlcn.tm.core.DTXContextRegistry;
import com.codingapi.txlcn.tm.core.TransactionManager;
import com.codingapi.txlcn.tm.core.storage.TransactionUnit;
import com.codingapi.txlcn.tm.support.service.TxExceptionService;
import com.codingapi.txlcn.tm.txmsg.MessageCreator;
import com.codingapi.txlcn.tm.txmsg.RpcExceptionHandler;
import com.codingapi.txlcn.txmsg.RpcClient;
import com.codingapi.txlcn.txmsg.dto.MessageDto;
import com.codingapi.txlcn.txmsg.exception.RpcException;
import com.codingapi.txlcn.txmsg.params.NotifyUnitParams;
import com.codingapi.txlcn.txmsg.util.MessageUtils;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SimpleTransactionManager
implements TransactionManager {
    private static final Logger log = LoggerFactory.getLogger(SimpleTransactionManager.class);
    private static final TxLogger txLogger = TxLogger.newLogger(SimpleTransactionManager.class);
    private final RpcExceptionHandler rpcExceptionHandler;
    private final RpcClient rpcClient;
    private final TxExceptionService exceptionService;
    private final DTXContextRegistry dtxContextRegistry;

    @Autowired
    public SimpleTransactionManager(RpcExceptionHandler rpcExceptionHandler, RpcClient rpcClient, TxExceptionService exceptionService, DTXContextRegistry dtxContextRegistry) {
        this.rpcExceptionHandler = rpcExceptionHandler;
        this.exceptionService = exceptionService;
        this.rpcClient = rpcClient;
        this.dtxContextRegistry = dtxContextRegistry;
    }

    @Override
    public void begin(String groupId) throws TransactionException {
        try {
            this.dtxContextRegistry.create(groupId);
        }
        catch (TransactionException e) {
            throw new TransactionException((Throwable)e);
        }
    }

    @Override
    public void join(DTXContext dtxContext, String unitId, String unitType, String modId, int userState) throws TransactionException {
        if (userState == 0) {
            dtxContext.resetTransactionState(0);
        }
        TransactionUnit transactionUnit = new TransactionUnit();
        transactionUnit.setModId(modId);
        transactionUnit.setUnitId(unitId);
        transactionUnit.setUnitType(unitType);
        dtxContext.join(transactionUnit);
    }

    @Override
    public void commit(DTXContext dtxContext) throws TransactionException {
        this.notifyTransaction(dtxContext, 1);
    }

    @Override
    public void rollback(DTXContext dtxContext) throws TransactionException {
        this.notifyTransaction(dtxContext, 0);
    }

    @Override
    public void close(String groupId) {
        this.dtxContextRegistry.destroyContext(groupId);
    }

    @Override
    public int transactionState(String groupId) {
        int state = this.exceptionService.transactionState(groupId);
        if (state != -1) {
            return state;
        }
        return this.dtxContextRegistry.transactionState(groupId);
    }

    @Override
    public int transactionStateFromFastStorage(String groupId) {
        return this.dtxContextRegistry.transactionState(groupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTransaction(DTXContext dtxContext, int transactionState) throws TransactionException {
        List<TransactionUnit> transactionUnits = dtxContext.transactionUnits();
        log.debug("group[{}]'s transaction units: {}", (Object)dtxContext.getGroupId(), transactionUnits);
        for (TransactionUnit transUnit : transactionUnits) {
            NotifyUnitParams notifyUnitParams = new NotifyUnitParams();
            notifyUnitParams.setGroupId(dtxContext.getGroupId());
            notifyUnitParams.setUnitId(transUnit.getUnitId());
            notifyUnitParams.setUnitType(transUnit.getUnitType());
            notifyUnitParams.setState(transactionState);
            txLogger.txTrace(dtxContext.getGroupId(), notifyUnitParams.getUnitId(), "notify {}'s unit: {}", new Object[]{transUnit.getModId(), transUnit.getUnitId()});
            try {
                List modChannelKeys = this.rpcClient.remoteKeys(transUnit.getModId());
                if (modChannelKeys.isEmpty()) {
                    throw new RpcException("offline mod.");
                }
                MessageDto respMsg = this.rpcClient.request((String)modChannelKeys.get(0), MessageCreator.notifyUnit(notifyUnitParams));
                if (MessageUtils.statusOk((MessageDto)respMsg)) continue;
                List<Object> params = Arrays.asList(notifyUnitParams, transUnit.getModId());
                this.rpcExceptionHandler.handleNotifyUnitBusinessException(params, (Throwable)respMsg.loadBean(Throwable.class));
            }
            catch (RpcException e) {
                List<Object> params = Arrays.asList(notifyUnitParams, transUnit.getModId());
                this.rpcExceptionHandler.handleNotifyUnitMessageException(params, e);
            }
            finally {
                txLogger.txTrace(dtxContext.getGroupId(), notifyUnitParams.getUnitId(), "notify unit over", new Object[0]);
            }
        }
    }
}

