package com.contentsquare.android.internal;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.contentsquare.android.ContentSquare;
import com.contentsquare.android.internal.logging.Logger;

/**
 * This class is a {@link ContentProvider} that allows our SDK be initialized with 0 lines of code.
 */

public class AutoStart extends ContentProvider {

    private final Logger mLogger = new Logger("AutoStart");

    @Override
    public boolean onCreate() {
        final Context context = getContext();
        String projectId;
        if (context != null) {
            mLogger.w("CS", "Context not null \\o/ we are good to go...");
            projectId = context.getPackageName();
            ContentSquare.startWithProjectId(context.getApplicationContext(), projectId);
        } else {
            mLogger.e("CS", "Context is null, crap.");
        }
        return true;
    }

    @Nullable
    @Override
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection,
            @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        return null;
    }

    @Nullable
    @Override
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    @Override
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        return null;
    }

    @Override
    public int delete(@NonNull Uri uri, @Nullable String selection,
            @Nullable String[] selectionArgs) {
        return 0;
    }

    @Override
    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection,
            @Nullable String[] selectionArgs) {
        return 0;
    }
}
