package com.contentsquare.android.internal.dagger.application;

import android.app.Application;
import android.support.annotation.NonNull;

import com.contentsquare.android.internal.ConfigurationCompositor;
import com.contentsquare.android.internal.DeviceInfo;
import com.contentsquare.android.internal.factories.TasksFactory;
import com.contentsquare.android.internal.preferences.PrefsHelper;
import com.contentsquare.android.internal.ui.glasspane.GlassPaneLayout;
import com.contentsquare.android.internal.util.AssetManager;
import com.contentsquare.android.internal.util.ConfigurationHelper;
import com.contentsquare.android.internal.util.DateTimeUtil;
import com.contentsquare.android.internal.util.UriBuilder;
import com.contentsquare.android.internal.util.ViewUtil;

import javax.inject.Singleton;

import dagger.Component;

/**
 * A Dagger Component containing the {@link ApplicationModule} which creates singletons for the
 * application lifecycle level.
 */
@Singleton
@Component(modules = {ApplicationModule.class})
public interface ApplicationComponent {
    /**
     * Returns an instance of the running {@link Application}.
     *
     * @return - an instance of the running {@link Application}
     */
    Application getApplication();

    /**
     * Returns an instance of {@link DeviceInfo}.
     *
     * @return - an instance of {@link DeviceInfo}
     */
    DeviceInfo getDeviceInfo();

    /**
     * Returns an instance of {@link PrefsHelper}.
     *
     * @return - an instance of {@link PrefsHelper}
     */
    PrefsHelper getPrefsHelper();

    /**
     * Returns an instance of {@link ConfigurationCompositor}.
     *
     * @return - an instance of {@link ConfigurationCompositor}
     */
    ConfigurationCompositor getConfigurationCompositor();

    /**
     * Returns an instance of {@link AssetManager}.
     *
     * @return - an instance of {@link AssetManager}
     */
    AssetManager getAssetManager();

    /**
     * Returns an instance of {@link TasksFactory}.
     *
     * @return - an instance of {@link TasksFactory}
     */
    TasksFactory getTasksFactory();

    /**
     * Returns an instance of {@link UriBuilder}.
     *
     * @return - an instance of {@link UriBuilder}
     */
    UriBuilder getUriBuilder();

    /**
     * Returns an instance of {@link ViewUtil}.
     *
     * @return - an instance of {@link ViewUtil}
     */
    ViewUtil getViewUtil();

    /**
     * Returns an instance of {@link DateTimeUtil}.
     *
     * @return - an instance of {@link DateTimeUtil}
     */
    DateTimeUtil getDateTimeUtil();

    /**
     * Injector for ConfigurationHelper objects.
     *
     * @param configurationHelper a non null transaction
     */
    void inject(@NonNull ConfigurationHelper configurationHelper);

    /**
     * Injector for {@see GlassPaneLayout} objects.
     *
     * @param glassPaneLayout a non null {@see GlassPaneLayout}.
     */
    void inject(@NonNull GlassPaneLayout glassPaneLayout);

}
