package com.contentsquare.android.internal.dagger.session;

import android.support.annotation.NonNull;

import com.contentsquare.android.internal.async.ThreadExecutor;

import dagger.Module;
import dagger.Provides;

/**
 * Module which will provide all Thread related singletons.
 */
@Module
public class AsyncModule {
    private final ThreadExecutor mThreadExecutor;

    /**
     * Constructor for the {@link ThreadExecutor} provider module.
     */
    public AsyncModule() {
        mThreadExecutor = new ThreadExecutor();
    }

    /**
     * Module provider which provides, the
     * {@link ThreadExecutor} which is linked to the session.
     * @return a HttpConnection worker instance
     */
    @Provides
    @NonNull
    public ThreadExecutor provideThreadPool() {
        return mThreadExecutor;
    }
}
