package com.contentsquare.android.internal.dagger.session;

import android.support.annotation.NonNull;

import com.contentsquare.android.internal.util.HttpConnection;

import dagger.Module;
import dagger.Provides;

/**
 * Dagger Singleton Module providing the running instance of {@link HttpConnection}.
 */
@Module
public class HttpModule {

    private final HttpConnection mConnector;

    /**
     * Constructor for the {@link HttpConnection} provider module.
     */
    public HttpModule() {
        mConnector = new HttpConnection();
    }

    /**
     * Module provider which provides, a
     * {@link HttpConnection}.
     * @return a HttpConnection worker instance
     */
    @Provides
    @NonNull
    public HttpConnection provideConnector() {
        return mConnector;
    }
}

