package com.contentsquare.android.internal.dagger.session;

import android.app.Application;
import android.support.annotation.NonNull;

import com.contentsquare.android.internal.dagger.UserScope;
import com.contentsquare.android.internal.events.processing.EventStorageManager;
import com.contentsquare.android.internal.events.processing.EventsProcessor;
import com.contentsquare.android.internal.model.EventsFactory;
import com.contentsquare.android.internal.model.JsonProxy;
import com.contentsquare.android.internal.ui.glasspane.GlassPane;
import com.contentsquare.android.internal.ui.glasspane.IGlassPane;

import dagger.Module;
import dagger.Provides;

/**
 * Dagger Singleton Module providing the running instance of {@link IGlassPane}.
 */
@Module
public class TrackingModule {
    /**
     * Module provider which provides, a {@link IGlassPane}.
     *
     * @param application the running app instance
     * @return a GlassPane worker instance
     */
    @Provides
    @UserScope
    @NonNull
    public IGlassPane provideGlass(@NonNull Application application) {
        return new GlassPane(application);
    }

    /**
     * Module provider which provides, a {@link EventsProcessor}.
     *
     * @return a EventsProcessor worker instance
     */
    @Provides
    @UserScope
    @NonNull
    EventsProcessor provideProcessor(@NonNull Application application) {
        return new EventsProcessor(new EventStorageManager(application.getApplicationContext()));
    }


    /**
     * Module provider which provides, a {@link EventsFactory}.
     *
     * @return an EventsFactory instance
     */
    @Provides
    @UserScope
    @NonNull
    EventsFactory provideEventsFactory() {
        return new EventsFactory();
    }

    /**
     * Module provider which provides, a {@link JsonProxy}.
     *
     * @return a JSon proxy instance for this session.
     */
    @Provides
    @UserScope
    @NonNull
    JsonProxy provideProxy() {
        return new JsonProxy();
    }
}

