package com.contentsquare.android.internal.factories;

import android.content.Context;
import android.support.annotation.NonNull;

import com.contentsquare.android.internal.ConfigurationCompositor;
import com.contentsquare.android.internal.async.ConfigRetrieverTask;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.util.AssetManager;
import com.contentsquare.android.internal.util.ConfigurationHelper;
import com.contentsquare.android.internal.util.HttpConnection;
import com.contentsquare.android.internal.util.UriBuilder;
import com.contentsquare.android.internal.validator.GodModeClipboardValidator;
import com.contentsquare.android.internal.validator.GodModeConfigValidator;

/**
 * This class should be injected in any class which needs/uses an AsyncTask. Through this you will
 * be able to inject/mock your AsyncTasks.
 */

public class TasksFactory {

    @NonNull
    private final UriBuilder mUriBuilder;
    @NonNull
    private final Context mContext;

    /**
     * Creates an instance of {@link TasksFactory}.
     *
     * @param uriBuilder as {@link UriBuilder}
     * @param context    use SingletonProvider to provide a context (using app.getBaseContext())
     */
    public TasksFactory(@NonNull UriBuilder uriBuilder, @NonNull Context context) {
        this.mUriBuilder = uriBuilder;
        this.mContext = context;
    }

    /**
     * Produces a new instance of {@link ConfigRetrieverTask}. It is highly recommended to use this
     * in order to favor composition and make your code testable.
     *
     * @param callback       as {@link ConfigRetrieverTask.ConfigProviderCallback}
     * @param httpConnection as {@link HttpConnection}
     * @param assetManager   as {@link AssetManager}
     * @param compositor     as {@link ConfigurationCompositor}
     * @param helper         as {@link ConfigurationHelper}
     * @return a new instance of the {@link ConfigRetrieverTask}
     */
    @NonNull
    public ConfigRetrieverTask produceConfigRetrieverTask(
            @NonNull ConfigRetrieverTask.ConfigProviderCallback callback,
            @NonNull HttpConnection httpConnection,
            @NonNull AssetManager assetManager,
            @NonNull ConfigurationCompositor compositor,
            @NonNull ConfigurationHelper helper) {
        return new ConfigRetrieverTask(callback,
                httpConnection,
                assetManager,
                compositor,
                helper,
                mUriBuilder,
                new GodModeClipboardValidator(mContext),
                new GodModeConfigValidator(),
                new Logger(ConfigRetrieverTask.TAG));
    }
}
