package com.contentsquare.android.internal.listeners;

import android.content.ComponentCallbacks;
import android.content.res.Configuration;
import android.support.annotation.NonNull;

import com.contentsquare.android.internal.DeviceInfo;
import com.contentsquare.android.internal.Session;
import com.contentsquare.android.internal.dagger.SingletonProvider;
import com.contentsquare.android.internal.dagger.session.SessionComponent;
import com.contentsquare.android.internal.events.processing.EventsProcessor;
import com.contentsquare.android.internal.model.data.LowMemoryEvent;

import org.json.JSONObject;

import javax.inject.Inject;

/**
 * Implementation of the {@link ComponentCallbacks} interface.
 * Listens for {@link ComponentCallbacks#onConfigurationChanged(Configuration)} and
 * {@link ComponentCallbacks#onLowMemory()} calls.
 */
public class CsComponentChange implements ComponentCallbacks {

    @Inject
    protected Session mSession;

    /**
     * Constructs an object which implements {@link ComponentCallbacks} and can track the
     * appropriate events for this library.
     */
    public CsComponentChange() {
        SingletonProvider.getSessionComponent().inject(this);
    }

    @Override
    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        // TODO: 10/1/17 [EVENT MISSING] screen rotation / resize event
    }

    @Override
    public void onLowMemory() {
        dispatchLowMemoryEvent();
        mSession.stopSession();
    }

    private void dispatchLowMemoryEvent() {
        final Runtime process = Runtime.getRuntime();
        final DeviceInfo deviceInfo = SingletonProvider
                .getAppComponent()
                .getDeviceInfo();
        final SessionComponent sessionComponent = SingletonProvider
                .getSessionComponent();
        final int availableFreeProcessMemory =
                deviceInfo.getCurrentAvailableFreeHeapMemory(process);
        final LowMemoryEvent lowMemoryEvent =
                new LowMemoryEvent.LowMemoryEventBuilder()
                        .currentAvailableMemory(availableFreeProcessMemory)
                        .build();
        final JSONObject toSend = sessionComponent.getJsonProxy().serializeToJson(lowMemoryEvent);

        if (toSend != null) {
            final EventsProcessor eventsProcessor = mSession.getEventsProcessor();
            eventsProcessor.processEvent(toSend);
        }
    }
}
