package com.contentsquare.android.internal.model;

import static com.contentsquare.android.internal.model.data.ActionEvent.APP_EXIT;
import static com.contentsquare.android.internal.model.data.ActionEvent.APP_HIDE;
import static com.contentsquare.android.internal.model.data.ActionEvent.APP_SHOW;
import static com.contentsquare.android.internal.model.data.ActionEvent.APP_START;
import static com.contentsquare.android.internal.model.data.ActionEvent.CRASH;
import static com.contentsquare.android.internal.model.data.ActionEvent.DOUBLE_TAP;
import static com.contentsquare.android.internal.model.data.ActionEvent.LONG_PRESS;
import static com.contentsquare.android.internal.model.data.ActionEvent.NO_EVENT;
import static com.contentsquare.android.internal.model.data.ActionEvent.PAGE_VIEW;
import static com.contentsquare.android.internal.model.data.ActionEvent.FLICK;
import static com.contentsquare.android.internal.model.data.ActionEvent.DRAG;
import static com.contentsquare.android.internal.model.data.ActionEvent.TAP;
import static com.contentsquare.android.internal.model.data.AppHideEvent.AppHideEventBuilder;
import static com.contentsquare.android.internal.model.data.CrashEvent.CrashEventBuilder;
import static com.contentsquare.android.internal.model.data.PageViewEvent.PageViewBuilder;

import android.support.annotation.NonNull;

import com.contentsquare.android.internal.model.data.ActionEvent;
import com.contentsquare.android.internal.model.data.ActionEvent.EventAction;
import com.contentsquare.android.internal.model.data.AppExitEvent.AppExitEventBuilder;
import com.contentsquare.android.internal.model.data.AppShowEvent.AppShowEventBuilder;
import com.contentsquare.android.internal.model.data.AppStartEvent.AppStartEventBuilder;
import com.contentsquare.android.internal.model.data.CrashEvent;
import com.contentsquare.android.internal.model.data.DoubleTapEvent.DoubleTapEventBuilder;
import com.contentsquare.android.internal.model.data.LongPressEvent.LongPressEventBuilder;
import com.contentsquare.android.internal.model.data.FlickEvent.FlickEventBuilder;
import com.contentsquare.android.internal.model.data.DragEvent.DragEventBuilder;
import com.contentsquare.android.internal.model.data.TapEvent.TapEventBuilder;

/**
 * A factory Producing data Builders.
 */
public class EventsFactory {

    /**
     * Returns a builder for the given type.
     *
     * @param type - the type
     * @param <T>  the class which is extended
     * @return the builder for this type
     */
    @NonNull
    @SuppressWarnings("unchecked")
    public <T extends ActionEvent.Builder> T produceEvent(@EventAction int type) {
        switch (type) {
            case PAGE_VIEW:
                return (T) new PageViewBuilder();
            case TAP:
                return (T) new TapEventBuilder();
            case DOUBLE_TAP:
                return (T) new DoubleTapEventBuilder();
            case LONG_PRESS:
                return (T) new LongPressEventBuilder();
            case FLICK:
                return (T) new FlickEventBuilder();
            case DRAG:
                return (T) new DragEventBuilder();
            case APP_START:
                return (T) new AppStartEventBuilder();
            case APP_SHOW:
                return (T) new AppShowEventBuilder();
            case APP_HIDE:
                return (T) new AppHideEventBuilder();
            case APP_EXIT:
                return (T) new AppExitEventBuilder();
            case CRASH:
                return (T) new CrashEventBuilder();
            case NO_EVENT:
            default:
                CrashEventBuilder builder = new CrashEventBuilder();
                builder.setCrashOrigin(CrashEvent.CRASH_SDK);
                builder.setMessage("EventsFactory.produceEvent was called with an invalid type");
                return (T) builder;
        }
    }
}
