package com.contentsquare.android.internal.model.data;

import android.support.annotation.NonNull;

/**
 * This is an event which describes the Application exit event.
 * This event is sent when a Client's app is considered as closed.
 */
public final class AppExitEvent extends ActionEvent {

    /**
     * Constructs an Event of the Application Exit type.
     */
    private AppExitEvent(AppExitEventBuilder builder) {
        super(builder);
    }

    /**
     * Builder class for a Application Hide Event.
     */
    public static class AppExitEventBuilder extends Builder<AppExitEvent> {

        /**
         * Constructs an Event of the type Application exit.
         */
        public AppExitEventBuilder() {
            super();
            setEventAction(APP_EXIT);
        }

        @Override
        @NonNull
        public AppExitEvent build() {
            return new AppExitEvent(this);

        }

    }
}