package com.contentsquare.android.internal.model.data;

import android.support.annotation.NonNull;

/**
 * This is an event which describes the Application hide event.
 * This event is sent when a Client's app is removed from the screen.
 */
public final class AppHideEvent extends ActionEvent {

    /**
     * Constructs an Event of the Application Start type.
     */
    private AppHideEvent(AppHideEventBuilder builder) {
        super(builder);
    }

    /**
     * Builder class for a Application Hide Event.
     */
    public static class AppHideEventBuilder extends Builder<AppHideEvent> {

        /**
         * Constructs an Event of the type Application hide.
         */
        public AppHideEventBuilder() {
            super();
            setEventAction(APP_HIDE);
        }

        @Override
        @NonNull
        public AppHideEvent build() {
            return new AppHideEvent(this);

        }

    }
}