package com.contentsquare.android.internal.model.data;

import android.support.annotation.NonNull;

/**
 * This is an event which describes the Application Show event.
 * This event is sent when a Client's app is Shown on the screen.
 */
public final class AppShowEvent extends ActionEvent {

    /**
     * Constructs an Event of the Application Start type.
     */
    private AppShowEvent(AppShowEventBuilder builder) {
        super(builder);
    }

    /**
     * Builder class for a Application Start Event.
     */
    public static class AppShowEventBuilder extends Builder<AppShowEvent> {

        /**
         * Constructs an Event of the type Application Show.
         */
        public AppShowEventBuilder() {
            super();
            setEventAction(APP_SHOW);
        }

        @Override
        @NonNull
        public AppShowEvent build() {
            return new AppShowEvent(this);

        }

    }
}