package com.contentsquare.android.internal.model.data;

import android.support.annotation.NonNull;

/**
 * This is an event which describes the Application Start event.
 * This event is sent when a Client's app is open/started.
 */
public final class AppStartEvent extends ActionEvent {

    /**
     * Constructs an Event of the Application Start type.
     */
    private AppStartEvent(AppStartEventBuilder builder) {
        super(builder);
    }

    /**
     * Builder class for a Application Start Event.
     */
    public static class AppStartEventBuilder extends Builder<AppStartEvent> {

        /**
         * Constructs an Event of the type Application Start.
         */
        public AppStartEventBuilder() {
            super();
            setEventAction(APP_START);
        }

        @Override
        @NonNull
        public AppStartEvent build() {
            return new AppStartEvent(this);

        }

    }
}