package com.contentsquare.android.internal.model.data;


import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

/**
 * This is an event which describes the Double Tap event.
 * This event is sent when a user interacts with the screen, performing a double tap.
 */
public class DoubleTapEvent extends ActionEvent {
    @NonNull
    private final String mTouchPath;
    @Nullable
    private final String mViewLabel;
    @Nullable
    private final String mViewId;
    @Nullable
    private final String mViewAccessibilityLabel;


    /**
     * Constructs an Event of the Double Tap type.
     */
    private DoubleTapEvent(DoubleTapEventBuilder builder) {
        super(builder);
        mTouchPath = builder.getTouchPath();
        mViewId = builder.getViewId();
        mViewLabel = builder.getViewLabel();
        mViewAccessibilityLabel = builder.getViewAccessibiltyLabel();
    }

    @NonNull
    public String getTouchPath() {
        return mTouchPath;
    }

    @Nullable
    public String getViewLabel() {
        return mViewLabel;
    }

    @Nullable
    public String getViewId() {
        return mViewId;
    }

    @Nullable
    public String getViewAccessibilityLabel() {
        return mViewAccessibilityLabel;
    }

    /**
     * Builder class for a Double Tap Event.
     */
    public static class DoubleTapEventBuilder extends Builder<DoubleTapEvent> {

        @NonNull
        private String mTouchPath;
        @Nullable
        private String mViewLabel;
        @Nullable
        private String mViewId;
        @Nullable
        private String mViewAccessibiltyLabel;

        /**
         * Constructs an Event of the type Double Tap.
         */
        public DoubleTapEventBuilder() {
            super();
            setEventAction(DOUBLE_TAP);
        }

        //CHECKSTYLE:OFF
        @NonNull
        public String getTouchPath() {
            return mTouchPath;
        }

        @NonNull
        public DoubleTapEventBuilder setTouchPath(@NonNull String touchPath) {
            mTouchPath = touchPath;
            return this;
        }

        @Nullable
        public String getViewLabel() {
            return mViewLabel;
        }

        @NonNull
        public DoubleTapEventBuilder setViewLabel(@Nullable String viewLabel) {
            mViewLabel = viewLabel;
            return this;
        }

        @Nullable
        public String getViewId() {
            return mViewId;
        }

        @NonNull
        public DoubleTapEventBuilder setViewId(@Nullable String viewId) {
            mViewId = viewId;
            return this;
        }

        @Nullable
        public String getViewAccessibiltyLabel() {
            return mViewAccessibiltyLabel;
        }

        @NonNull
        public DoubleTapEventBuilder setViewAccessibilityLabel(@Nullable String viewAccessibiltyLabel) {
            mViewAccessibiltyLabel = viewAccessibiltyLabel;
            return this;
        }
        //CHECKSTYLE:ON

        @Override
        @NonNull
        public DoubleTapEvent build() {
            return new DoubleTapEvent(this);
        }
    }
}
