package com.contentsquare.android.internal.model.data;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

/**
 * This is an event which describes the Long Press event.
 * This event is sent when a user interacts with the screen, performing a long press.
 */
public class LongPressEvent extends ActionEvent {

    @NonNull
    private final String mTouchPath;
    @Nullable
    private final String mViewLabel;
    @Nullable
    private final String mViewId;
    @Nullable
    private final String mViewAccessibilityLabel;

    /**
     * Constructs an Event of the Long Press type.
     */
    private LongPressEvent(LongPressEventBuilder builder) {
        super(builder);
        mTouchPath = builder.getTouchPath();
        mViewLabel = builder.getViewLabel();
        mViewId = builder.getViewId();
        mViewAccessibilityLabel = builder.getViewAccessibilityLabel();
    }

    @NonNull
    public String getTouchPath() {
        return mTouchPath;
    }

    @Nullable
    public String getViewLabel() {
        return mViewLabel;
    }

    @Nullable
    public String getViewId() {
        return mViewId;
    }

    @Nullable
    public String getViewAccessibilityLabel() {
        return mViewAccessibilityLabel;
    }

    /**
     * Builder class for a Long Press Event.
     */
    public static class LongPressEventBuilder extends Builder<LongPressEvent> {

        @NonNull
        private String mTouchPath;
        @Nullable
        private String mViewLabel;
        @Nullable
        private String mViewId;
        @Nullable
        private String mViewAccessibilityLabel;

        /**
         * Constructs an Event of the type Long Press.
         */
        public LongPressEventBuilder() {
            super();
            setEventAction(LONG_PRESS);
        }

        //CHECKSTYLE:OFF
        @NonNull
        public String getTouchPath() {
            return mTouchPath;
        }

        @NonNull
        public LongPressEventBuilder setTouchPath(@NonNull String touchPath) {
            mTouchPath = touchPath;
            return this;
        }

        @Nullable
        public String getViewLabel() {
            return mViewLabel;
        }

        @NonNull
        public LongPressEventBuilder setViewLabel(@Nullable String viewLabel) {
            mViewLabel = viewLabel;
            return this;
        }

        @Nullable
        public String getViewId() {
            return mViewId;
        }

        @NonNull
        public LongPressEventBuilder setViewId(@Nullable String viewId) {
            mViewId = viewId;
            return this;
        }

        @Nullable
        public String getViewAccessibilityLabel() {
            return mViewAccessibilityLabel;
        }

        @NonNull
        public LongPressEventBuilder setViewAccessibilityLabel(
                @Nullable String viewAccessibilityLabel) {
            mViewAccessibilityLabel = viewAccessibilityLabel;
            return this;
        }
        //CHECKSTYLE:ON

        @NonNull
        @Override
        public LongPressEvent build() {
            return new LongPressEvent(this);
        }
    }
}
