package com.contentsquare.android.internal.model.data;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

/**
 * This is an event which describes the equivalent of a "page view" in the web.
 * This event is sent when a Screen/Page change is detected.
 */
public final class PageViewEvent extends ActionEvent {

    @Nullable
    private final String mTitle;
    private final int mLoadTime;

    /**
     * Constructs an Event of the appropriate type.
     */
    private PageViewEvent(PageViewBuilder builder) {
        super(builder);
        mLoadTime = builder.getLoadTime();
        mTitle = builder.getTitle();
    }

    @Nullable
    public String getTitle() {
        return mTitle;
    }

    public int getLoadTime() {
        return mLoadTime;
    }

    /**
     * Builder class for a PageView Event.
     */
    public static class PageViewBuilder extends Builder<PageViewEvent> {

        private String mTitle;
        private int mLoadTime;

        /**
         * Constructs an Event of the type PageView.
         */
        public  PageViewBuilder() {
            setEventAction(PAGE_VIEW);
        }

        //CHECKSTYLE:OFF
        public String getTitle() {
            return mTitle;
        }

        public PageViewBuilder setTitle(@Nullable String title) {
            mTitle = title;
            return this;
        }

        public int getLoadTime() {
            return mLoadTime;
        }

        public PageViewBuilder setLoadTime(int loadTime) {
            mLoadTime = loadTime;
            return this;
        }
        //CHECKSTYLE:ON

        @Override
        @NonNull
        public PageViewEvent build() {
            return new PageViewEvent(this);

        }
    }
}