package com.contentsquare.android.internal.screengraph;

import android.support.annotation.NonNull;

import com.contentsquare.android.internal.logging.Logger;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Data representation of a serializable Metadata.
 */

public class JsonMetadataView {

    private static final String CLASS_NAME = "class_name";
    private static final String FULL_PATH = "fullpath";
    private static final String CHILD_ORDER = "child_order";

    private String mClassName;
    private String mFullPath;
    private int mChildOrder;

    public String getClassName() {
        return mClassName;
    }

    public void setClassName(String className) {
        this.mClassName = className;
    }

    public String getFullPath() {
        return mFullPath;
    }

    public void setFullPath(String fullPath) {
        this.mFullPath = fullPath;
    }

    public int getChildOrder() {
        return mChildOrder;
    }

    public void setChildOrder(int childOrder) {
        mChildOrder = childOrder;
    }

    /**
     * Get a Json representation of the instance of that class.
     *
     * @return a JSONObject that contains all the metatada that was set in this class
     */
    @NonNull
    public JSONObject toJson() {

        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(CLASS_NAME, getClassName());
            jsonObject.put(FULL_PATH, getFullPath());
            jsonObject.put(CHILD_ORDER, getChildOrder());
        } catch (JSONException e) {
            new Logger("JsonMetadataView").w("Failed to build metadata object %s", e.getMessage());
        }

        return jsonObject;

    }

}
