package com.contentsquare.android.internal.screengraph;

import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

/**
 * Data representation of the root view in a Screengraph.
 */
public class Screen {

    @VisibleForTesting
    static final String WIDTH = "device_width";
    @VisibleForTesting
    static final String HEIGHT = "device_height";
    @VisibleForTesting
    static final String VERSION = "version_sdk";
    @VisibleForTesting
    static final String CHILDREN = "views";
    @VisibleForTesting
    static final String VERSION_JSON = "version_json";
    @VisibleForTesting
    static final String VERSION_APP = "version_app";
    @VisibleForTesting
    static final String URL = "url";
    @VisibleForTesting
    static final String HASH_ID = "hash_id";

    private int mWidth;
    private int mHeight;
    private String mVersion;
    private List<JsonView> mChildren;
    private String mVersionJson;
    private String mVersionApp;
    private String mUrl;
    // this will contain the values of the hashcode for the targetPath of this view
    private int mHashId;

    public int getWidth() {
        return mWidth;
    }

    public void setWidth(int width) {
        mWidth = width;
    }

    public int getHeight() {
        return mHeight;
    }

    public void setHeight(int height) {
        mHeight = height;
    }

    public String getVersion() {
        return mVersion;
    }

    public void setVersion(String version) {
        mVersion = version;
    }

    public List<JsonView> getChildren() {
        return mChildren;
    }

    public void setChildren(List<JsonView> children) {
        mChildren = children;
    }

    public String getVersionJson() {
        return mVersionJson;
    }

    public void setVersionJson(String versionJson) {
        mVersionJson = versionJson;
    }

    public String getVersionApp() {
        return mVersionApp;
    }

    public void setVersionApp(String versionApp) {
        mVersionApp = versionApp;
    }

    public String getUrl() {
        return mUrl;
    }

    public void setUrl(String url) {
        mUrl = url;
    }

    public void setHashId(int hashId) {
        this.mHashId = hashId;
    }

    public int getHashId() {
        return mHashId;
    }

    /**
     * Returns a {@link JSONObject} with the values corresponding to the current object. This
     * method
     *
     * @return returns null if current object is either null or empty.
     * @throws JSONException in the case a serialization issue occurs.
     */
    @Nullable
    public JSONObject toJson() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();

        jsonObject.put(HEIGHT, getHeight());
        jsonObject.put(WIDTH, getWidth());
        jsonObject.put(VERSION, getVersion());
        jsonObject.put(VERSION_JSON, getVersionJson());
        jsonObject.put(VERSION_APP, getVersionApp());
        jsonObject.put(URL, getUrl());
        jsonObject.put(HASH_ID, getHashId());

        for (JsonView obj : getChildren()) {
            jsonArray.put(obj.toJson());
        }
        jsonObject.put(CHILDREN, jsonArray);
        return jsonObject;
    }

}
