package com.contentsquare.android.internal.screengraph;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.ViewGroup;

import com.contentsquare.android.internal.logging.Logger;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * The SceneGrpah is used to show the hierarchical view of Layout TreeView.
 */
public class Screengraph {

    /**
     * Generates a Screengraph for this screen. The Screengraph is an extensive serialization of
     * this screen to a JSon object.
     * Note: Super Heavy method! this should not be called in production for the time being.
     * We need to figure out IF we can run this on a separate thread as this method
     *
     * @param rootView FrameLayout of the TreeView entry point.
     * @param url      as {@link String} the url of the current ViewGroup
     * @param hashId   as {@code int} - unique id based on the hashcode of touch target path
     * @return JSON Object with the tree view.
     */
    @Nullable
    public JSONObject obtain(@NonNull ViewGroup rootView, @Nullable String url, int hashId) {
        Logger logger = new Logger("Screengraph");
        Screen graph = getTraverser().traverse(rootView, url, hashId);
        try {
            logger.d("Obtaining graph from %s", rootView.toString());
            return graph.toJson();
        } catch (JSONException e) {
            logger.w(e, "Failed to Serialized Scenegraph to JSON");
            return null;
        }

    }

    @VisibleForTesting
    @NonNull
    TreeTraverser getTraverser() {
        return new TreeTraverser();
    }

}
