package com.contentsquare.android.internal.screenmonitoring;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;

/**
 * Used to notify the third party whenever a screen change occurred in an Activity.
 */
public interface IScreenChangedCallback {
    /**
     * Tells if an activity changed its screen by performing a new fragment transaction.
     *  @param activity    the {@link Activity} on which the screen was changed.
     * @param fragment    the {@link Fragment} that was added.
     * @param loadingTime as {@link Long}
     */
    void onScreenChanged(@NonNull Activity activity, @NonNull Fragment fragment, int loadingTime);
}
