package com.contentsquare.android.internal.screenmonitoring;

import android.app.Activity;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;

/**
 * This is the entry point for any {@link android.app.Activity} which needs to detect whenever
 * a new major screen change took place in order to notify the interested callback.
 * This service has its logic based on the strategy pattern and implies the usage of a different
 * strategy for each Activity type.
 */

public interface IScreenMonitoringService {

    /**
     * Tries to find a strategy for the current {@link Activity} type and to attaches itself
     * using the found strategy logic.
     *
     * @param activity as {@link Activity} where to attach the monitor.
     * @param callback as the {@link com.contentsquare.android.internal.screenmonitoring
     *                 .ScreenMonitoringService.IScreenChangedCallback}
     * @return true if the Monitor was successfully attached.
     */
    @CheckResult
    boolean attachTo(@NonNull Activity activity, IScreenChangedCallback callback);

    /**
     * Detaches itself from the current activity.F
     *
     * @param activity as {@link Activity}
     */
    void detachFrom(@NonNull Activity activity);
}
