package com.contentsquare.android.internal.screenmonitoring;

import com.contentsquare.android.internal.dagger.UserScope;

import dagger.Module;
import dagger.Provides;

/**
 * The Dagger Module related with the screen monitoring package. It will provide all the required
 * dependencies from this package.
 */

@Module
public class ScreenMonitoringModule {

    /**
     * Provide a new instance of {@link IScreenMonitoringService} which lives as a singleton in
     * Session's scope.
     *
     * @return a new instance of {@link IScreenMonitoringService}
     */
    @Provides
    @UserScope
    public IScreenMonitoringService provideScreenMonitoringService() {
        return new ScreenMonitoringService(
        );
    }
}
