package com.contentsquare.android.internal.screenmonitoring.strategies;

import android.app.Activity;
import android.support.annotation.NonNull;

import com.contentsquare.android.internal.screenmonitoring.IScreenChangedCallback;

/**
 * Dummy implementation of the {@link IActivityMonitoringStrategy}. Contains empty logic and it
 * can be used in case there is no real strategy that can be applied for a specific activity.
 */

public class DummyStrategy implements IActivityMonitoringStrategy {

    @Override
    public boolean attachTo(@NonNull Activity activity, @NonNull IScreenChangedCallback callback) {
        return false;
    }

    @Override
    public void detachFrom(@NonNull Activity activity) {

    }

    @Override
    public IScreenChangedCallback callback(@NonNull Activity activity) {
        return null;
    }
}
