package com.contentsquare.android.internal.screenmonitoring.strategies;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;

import com.contentsquare.android.internal.screenmonitoring.IScreenChangedCallback;

/**
 * The strategy interface to be used inside the
 * {@link com.contentsquare.android.internal.screenmonitoring.ScreenMonitoringService} for
 * monitoring the attached activities.
 */

public interface IActivityMonitoringStrategy {

    /**
     * Tries to attaches itself to the provided activity and to monitor the fragment/screen changes.
     *
     * @param activity as the {@link Activity} to attach to.
     * @param callback as the {@link IScreenChangedCallback}
     * @return true if the attachment was successful.
     */
    boolean attachTo(@NonNull Activity activity, @NonNull IScreenChangedCallback callback);

    /**
     * Detaches itself from the provided activity.
     *
     * @param activity as {@link Activity} to detach from.
     */
    void detachFrom(@NonNull Activity activity);

    /**
     * Meant only to be used in tests.
     *
     * @param activity as the {@link Activity}
     *                 for which you requested the {@link IScreenChangedCallback}
     * @return the current {@link IScreenChangedCallback}
     */
    @RestrictTo(RestrictTo.Scope.TESTS)
    IScreenChangedCallback callback(@NonNull Activity activity);
}
