package com.contentsquare.android.internal.ui.glasspane;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.widget.FrameLayout;

/**
 * The IGlassPane is the interface to an implementation of a composit of a View
 * and it's TouchListener. This is the transparent View which is injected in the
 * Activity's view hierarchy on the DecorView lFevel. This is the main touch interceptor.
 */

public interface IGlassPane {
    /**
     * Gets the View which is Injected.
     *
     * @return View the view which is injected.
     */
    @NonNull
    GlassPaneLayout getGlassPaneLayout();

    /**
     * Attaches the GlassPane to an Activity.
     *
     * @param liveActivity the activity which we're supposed to inject into.
     */
    void attachGlassPane(@NonNull Activity liveActivity);

    /**
     * Detaches the GlassPane from an Activity.
     *
     * @param liveActivity the activity which we're supposed to remove the glass from.
     */
    void detachGlassPane(@Nullable Activity liveActivity);

    /**
     * Stops all listeners and clear the session from the touch listener.
     */
    void stopSession();

    /**
     * Conveys a pause call to the listener.
     */
    void pauseListeners();

    /**
     * Conveys an un-pause call to the listener.
     */
    void resumeListeners();

    /**
     * Returns the Decor View.
     *
     * @return the decor view as {@link FrameLayout}
     */
    @Nullable
    FrameLayout getDecorView();

    /**
     * Get current screen's URL.
     * @return the url.
     */
    @Nullable
    String getCurrentScreenUrl();

    /**
     * Set the current screen's URL.
     * @param url the url of the current screen the glass pane is linked to.
     */
    void setCurrentScreenUrl(@Nullable String url);
}
