package com.contentsquare.android.internal.ui.processor.descriptors;

import static com.contentsquare.android.internal.util.ResourceUtils.getResourceEntryName;

import android.os.Build;
import android.support.annotation.NonNull;
import android.view.View;

import com.contentsquare.android.internal.util.ResourceUtils;

/**
 * Descriptor for a {@link android.view.View}
 */
public class ViewDescriptor extends PlaneDescriptor {

    /**
     * Builds a View descriptor from the original {@link View}.
     *
     * @param view the view for which we're building a descriptor
     */
    public ViewDescriptor(@NonNull View view) {
        super(view);
        setClassName(view.getClass().getSimpleName());
        if (view.getId() > 0) {
            setViewResourceId(getResourceEntryName(view, ResourceUtils.NULL_STRING_ID));
            setViewId(view.getId());
        }
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            setAccessibilityClassName(view.getAccessibilityClassName());
        } else {
            setAccessibilityClassName("");
        }
        setEnabled(view.isEnabled());
        setActivated(view.isActivated());
        setClickable(view.isClickable());
        setFocusable(view.isFocusable());
        setFocused(view.isFocused());
        setShown(view.isShown());
        setVisible(view.getVisibility() == View.VISIBLE);
    }

}
