package com.contentsquare.android.internal.ui.processor.descriptors;

import static com.contentsquare.android.internal.util.ResourceUtils.NULL_STRING_ID;
import static com.contentsquare.android.internal.util.ResourceUtils.getResourceEntryName;

import android.os.Build;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;

/**
 * Descriptor for a {@link android.view.ViewGroup}.
 */
public class ViewGroupDescriptor extends PlaneDescriptor {
    /**
     * Constructs a ViewGroup Descriptor.
     */
    public ViewGroupDescriptor(@NonNull ViewGroup viewGroup) {
        super(viewGroup);
        setClassName(viewGroup.getClass().getSimpleName());
        if (viewGroup.getId() > 0) {
            setViewId(viewGroup.getId());
            setViewResourceId(getResourceEntryName(viewGroup, NULL_STRING_ID));
        }

        setChildCount(viewGroup.getChildCount());
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            setAccessibilityClassName(viewGroup.getAccessibilityClassName());
            setTouchBlockingFocus(viewGroup.getTouchscreenBlocksFocus());
        } else {
            setAccessibilityClassName("");
            setTouchBlockingFocus(false);
        }
        setEnabled(viewGroup.isEnabled());
        setActivated(viewGroup.isActivated());
        setClickable(viewGroup.isClickable());
        setFocusable(viewGroup.isFocusable());
        setFocused(viewGroup.isFocused());
        setShown(viewGroup.isShown());
        setVisible(viewGroup.getVisibility() == View.VISIBLE);


    }
}
