package com.contentsquare.android.internal.util;

import android.app.Activity;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.contentsquare.android.internal.logging.Logger;

/**
 * Utility class relating to processing sdk related requests.
 */

public final class FrameworkUtility {

    private static final Logger LOG = new Logger("FrameworkUtil");

    private FrameworkUtility() {
    }

    /**
     * Returns the activity description from the manifest.
     *
     * @param activity the activity for which we query.
     * @return a title, or null in the case of an error.
     */
    @Nullable
    public static String getActivityTitle(@NonNull Activity activity) {
        ActivityInfo activityInfo;
        try {
            activityInfo = activity.getPackageManager().getActivityInfo(
                    activity.getComponentName(),
                    PackageManager.GET_META_DATA);
            return activityInfo.loadLabel(activity.getPackageManager()).toString();
        } catch (PackageManager.NameNotFoundException | NullPointerException e) {
            LOG.i("Failed to get the activity title, %s", e.getMessage());
        }
        return null;
    }
}
