package com.contentsquare.android.internal.util;

import android.support.annotation.Nullable;

import com.contentsquare.android.internal.logging.Logger;

import java.security.MessageDigest;

/**
 * String representation of a md5 Hash.
 */
public class MD5Hash {
    @Nullable
    private String mData = null;

    /**
     * A constructor which receives a string which is supposed to be hashed.
     * @param dataToHash the data to be hashed
     */
    public MD5Hash(@Nullable String dataToHash) {
        if (!Strings.isNullOrEmpty(dataToHash)) {
            try {
                MessageDigest hashEngine = MessageDigest.getInstance("MD5");
                hashEngine.update(dataToHash.getBytes("iso-8859-1"), 0, dataToHash.length());
                mData = convertByteArrayToHexString(hashEngine.digest());
            } catch (Exception e) {
                new Logger("MD5").e(e, "error in calculating MD5 sum ");
                //NO-OP
            }
        }
    }

    /**
     * Convert byte array to hex string.
     * @param data Target data array.
     * @return Hex string.
     */
    @Nullable
    private static String convertByteArrayToHexString(@Nullable byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }

        // CHECKSTYLE:OFF
        final StringBuilder buffer = new StringBuilder();
        for (int byteIndex = 0; byteIndex < data.length; byteIndex++) {
            int halfbyte = (data[byteIndex] >>> 4) & 0x0F;
            int twoHalfs = 0;
            do {
                if ((0 <= halfbyte) && (halfbyte <= 9)) {
                    buffer.append((char) ('0' + halfbyte));
                } else {
                    buffer.append((char) ('a' + (halfbyte - 10)));
                }
                halfbyte = data[byteIndex] & 0x0F;
            } while (twoHalfs++ < 1);
        }
        // CHECKSTYLE:ON

        return buffer.toString();
    }

    /**
     * Gets the MD5 Hash value.
     * @return a string of the hash.
     */
    @Nullable
    public String getMd5Hash() {
        return mData;
    }
}
