package com.contentsquare.android.internal.util;

import android.annotation.TargetApi;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

/**
 * Wrapper around getting a random number.
 */
public class RandomGenerator {
    private static final int COMPLETE_AUDIENCE = 100;
    @NonNull
    private static final Random RANDOM = new Random();

    @VisibleForTesting
    RandomGenerator() {
        //to assure that this class is not instantiated
        throw new UnsupportedOperationException("This class cannot be instantiated.");
    }

    /**
     * Calculates a random number between 0 and 100, representing a random audience percentage.
     * @return a random int between 0 and 100.
     */
    public static int getRandomAudiencePercentage() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            return getRandomPostLollipop();
        } else {
            return getRandomPreLollipop();
        }
    }

    @VisibleForTesting
    static int getRandomPreLollipop() {
        return RANDOM.nextInt(COMPLETE_AUDIENCE);
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    @VisibleForTesting
    static int getRandomPostLollipop() {
        return ThreadLocalRandom.current().nextInt(COMPLETE_AUDIENCE);
    }
}
