package com.contentsquare.android.internal.util;

import android.os.Looper;
import android.support.annotation.AnyThread;

/**
 * Utilities related to working with {@link Thread}s.
 */

public class ThreadUtils {

    /**
     * Prevent object instantiations.
     */
    private ThreadUtils() {
    }

    /**
     * Checks if the caller {@link Thread} is the UI thread using {@link Looper#getMainLooper()}.
     *
     * @return true if the caller thread is the main thread.
     */
    @AnyThread
    public static boolean uiThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }
}
